/*  SpiralLoops
 *  Copyleft (C) 2000 David Griffiths <dave@pawfal.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "SpiralLoopsInfo.h"

int    SpiralInfo::BUFSIZE     = 512;	
int    SpiralInfo::SAMPLERATE  = 44100;
long   SpiralInfo::MAXSAMPLE   = 32767;
float  SpiralInfo::VALUECONV   = 1.0f/MAXSAMPLE;
bool   SpiralInfo::WANTMIDI    = false;
int    SpiralInfo::FILTERGRAN  = 50;
string SpiralInfo::OUTPUTFILE  = "/dev/dsp";
string SpiralInfo::MIDIFILE    = "/dev/midi";
int    SpiralInfo::POLY        = 1;
bool   SpiralInfo::REALTIMEOUT = true;

int SpiralInfo::GUI_COLOUR = 139;
int SpiralInfo::GUIBG_COLOUR = 0;
int SpiralInfo::GUIBG2_COLOUR = 49;//45;


SpiralLoopsInfo* SpiralLoopsInfo::m_SpiralLoopsInfo=NULL;

SpiralLoopsInfo* SpiralLoopsInfo::Get()
{
	if (!m_SpiralLoopsInfo)
	{
		m_SpiralLoopsInfo = new SpiralLoopsInfo;
	}
	
	return m_SpiralLoopsInfo;
}
