#
# This file is part of SickGear.
#
# SickGear is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# SickGear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SickGear.  If not, see <http://www.gnu.org/licenses/>.

import sickgear
from .scheduler import Job
from sickgear import watchedstate_queue


class WatchedStateUpdater(Job):
    def __init__(self, name, queue_item):
        super(WatchedStateUpdater, self).__init__(self.job_run, silent=True, kwargs={}, thread_lock=True)

        self.name = name
        self.queue_item = queue_item

    @property
    def prevent_run(self):
        return sickgear.watched_state_queue_scheduler.action.is_in_queue(self.queue_item)

    @staticmethod
    def is_enabled():
        return True

    def job_run(self):
        # noinspection PyUnresolvedReferences
        if self.is_enabled():
            new_item = self.queue_item()
            sickgear.watched_state_queue_scheduler.action.add_item(new_item)


class EmbyWatchedStateUpdater(WatchedStateUpdater):

    def __init__(self):
        super(EmbyWatchedStateUpdater, self).__init__('Emby', watchedstate_queue.EmbyWatchedStateQueueItem)

    @staticmethod
    def is_enabled():
        return sickgear.USE_EMBY and sickgear.EMBY_WATCHEDSTATE_SCHEDULED


class PlexWatchedStateUpdater(WatchedStateUpdater):

    def __init__(self):
        super(PlexWatchedStateUpdater, self).__init__('Plex', watchedstate_queue.PlexWatchedStateQueueItem)

    @staticmethod
    def is_enabled():
        return sickgear.USE_PLEX and sickgear.PLEX_WATCHEDSTATE_SCHEDULED
