% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fundamental.matrix.R
\name{fundamental.matrix}
\alias{fundamental.matrix}
\title{Fundamental matrix and age-specific survival}
\usage{
fundamental.matrix(A, ...)
}
\arguments{
\item{A}{projection matrix}

\item{\dots}{additional items are passed to \code{\link{splitA}} and are
used to split A into T and F matrices}
}
\value{
A list with 5 items
\item{N}{ fundamental matrix or mean of the time spent in each stage class}
\item{var}{ variance of the time spent in each stage class}
\item{cv}{ coefficient of variation (sd/mean) }
\item{meaneta}{ mean of time to death}
\item{vareta}{ variance of time to death }
}
\description{
Age-specific survival calculations from stage-classified matrices.  Includes
the mean, variance and coefficient of variation (cv) of the time spent in
each stage class and the mean and variance of the time to death
}
\details{
see section 5.3.1 in Caswell (2001).
}
\examples{
fundamental.matrix(whale)

}
\references{
Caswell, H. 2001. Matrix population models: construction,
analysis, and interpretation, Second edition. Sinauer, Sunderland,
Massachusetts, USA.
}
\seealso{
see \code{\link{generation.time}} and \code{\link{net.reproductive.rate}}
for other age-specific traits
}
\author{
Chris Stubben
}
