/*
 * Decompiled with CFR 0.152.
 */
package rfb;

import rdr.InStream;
import rfb.CMsgHandler;
import rfb.CMsgReader;
import rfb.Exception;
import rfb.LogWriter;
import rfb.PixelFormat;

public class CMsgReaderV3
extends CMsgReader {
    int nUpdateRectsLeft;
    static LogWriter vlog = new LogWriter("CMsgReaderV3");

    public CMsgReaderV3(CMsgHandler handler_, InStream is_) {
        super(handler_, is_);
    }

    public void readServerInit() {
        int width = this.is.readU16();
        int height = this.is.readU16();
        this.handler.setDesktopSize(width, height);
        PixelFormat pf = new PixelFormat();
        pf.read(this.is);
        this.handler.setPixelFormat(pf);
        String name = this.is.readString();
        this.handler.setName(name);
        this.endMsg();
        this.handler.serverInit();
    }

    public void readMsg() {
        block12: {
            block11: {
                if (this.nUpdateRectsLeft != 0) break block11;
                int type = this.is.readU8();
                switch (type) {
                    case 0: {
                        this.readFramebufferUpdate();
                        break block12;
                    }
                    case 1: {
                        this.readSetColourMapEntries();
                        break block12;
                    }
                    case 2: {
                        this.readBell();
                        break block12;
                    }
                    case 3: {
                        this.readServerCutText();
                        break block12;
                    }
                    default: {
                        vlog.error("unknown message type " + type);
                        throw new Exception("unknown message type");
                    }
                }
            }
            int x = this.is.readU16();
            int y = this.is.readU16();
            int w = this.is.readU16();
            int h = this.is.readU16();
            int encoding = this.is.readU32();
            switch (encoding) {
                case -223: {
                    this.handler.setDesktopSize(w, h);
                    break;
                }
                case -239: {
                    this.readSetCursor(x, y, w, h);
                    break;
                }
                default: {
                    this.readRect(x, y, w, h, encoding);
                }
            }
            --this.nUpdateRectsLeft;
            if (this.nUpdateRectsLeft == 0) {
                this.handler.framebufferUpdateEnd();
            }
        }
    }

    void readFramebufferUpdate() {
        this.is.skip(1);
        this.nUpdateRectsLeft = this.is.readU16();
        this.endMsg();
        this.handler.framebufferUpdateStart();
    }
}

