;;########################################################################
;; dashobj4.lsp
;; Contains code to manipulate and close datasheet.
;; Copyright (c) 1994-8 by Forrest W. Young
;;########################################################################


(defun change-matrix-names () (send *datasheet* :change-matrix-names))

(defmeth datasheet-proto :change-matrix-names () 
  (let* ((result (send (send self :matrix-names-dialog-box) :modal-dialog))
         (names (copy-list (send self :matrix-strings))))
    (when result
          (cond ((first result) 
                 (setf (select names (first result)) (second result))
                 (send self :edited t)
                 (send self :matrix-strings names))
            (t (error-message "You must select a name to change."))))))

(defmeth datasheet-proto :matrix-names-dialog-box ()
"Returns list of matrix names, or nil if canceled."
  (let* ((heading (send text-item-proto :new "Change Matrix Names:"))
         (step1   (send text-item-proto :new "1) Select Name to Change:"))
         (matlist (send list-item-proto :new (send self :matrix-strings)))
         (step2   (send text-item-proto :new "2) Type New Name:"))
         (newname (send edit-text-item-proto :new "" :text-length 24))
         (cancel  (send modal-button-proto :new "Cancel"))
         (ok      (send modal-button-proto :new "OK" :action #'(lambda () 
                    (list (send matlist :selection) 
                          (send newname :text))))))
    (send modal-dialog-proto :new
               (list heading step1 matlist step2 newname (list ok cancel))
          :default-button ok)))

(defun switch-label-variable () (send *datasheet* :switch-label-variable))

(defmeth datasheet-proto :switch-label-variable ()
  (let* ((varnum (send (send self :label-dialog-box) :modal-dialog))
         (data (send self :data-matrix-strings))
         (labels (send self :label-strings))
         (names (send *datasheet* :variable-strings))
         (types (send self :type-strings))
         (var nil)
         (nobs nil)
         )
    (when varnum
          (setf varnum (first varnum))
          (cond 
            ((not varnum) (error-message "You must select a variable."))
            (t
             (setf var (col data varnum))
             (setf nobs (length var))
             (send self :label-strings var) 
             (setf (select data (iseq nobs) varnum) 
                   (matrix (list nobs 1) labels))
             (send self :data-matrix-strings data)
             (setf (select types varnum) "Category")
             (setf (select names varnum) "Label")
             (send self :edited t)
             (send self :redraw))))))
          
(defmeth datasheet-proto :label-dialog-box ()
"Returns list of selected variables, or (nil) if none selected, or nil if canceled."
  (let* ((heading (send text-item-proto :new 
           (format nil "Switch the Label Variable~%with the Data Variable~%you select below:")))
         (varlist (send list-item-proto :new (send self :variable-strings)))
         (cancel    (send modal-button-proto :new "Cancel"))
         (ok        (send modal-button-proto :new "OK" :action #'(lambda () 
                    (list (send varlist :selection))))))
    (send modal-dialog-proto :new
               (list heading varlist (list ok cancel))
          :default-button ok)
        ))

(defmeth datasheet-proto :enable-menu-items (nilt)
  (let ((menu (send self :menu)))
    (send (select (send menu :items) 6) :enabled nilt)
    (send (select (send menu :items) 7) :enabled nilt)
    (send (select (send menu :items) 9) :enabled nilt)))

(defmeth datasheet-proto :close ()
  (cond
    ((or (send self :new-data) 
         (and (send self :edited) (send self :editable)))
     (let ((result (send self :close-dialog)))
       (when result
             (if (first result)
                 (send (send self :data-object) 
                       :save-data nil (not (second result)) t)
                 (send self :discard-changes))
             (send *about-window* :hide-window)
             )))
    (t
     (send self :close-datasheet)
     (send *about-window* :hide-window)
     ))
  #+macintosh(apply #'send self :size (- (send self :size) '(15 0)))
  )

(defmeth datasheet-proto :close-dialog ()
"Args: none"
  (let* ((dob   (send self :data-object))
         (name  (send dob :name))
         (name  (if (> (length name) 8) (select name (iseq 7)) name))
         (family (or (send dob :dob-parents)
                     (send dob :dob-children)))
       ; (action (if family "Create a New ViSta" "Update ViSta's"))
         (action (if family "Create New" "Update"))
         (os
#+macintosh "Macintosh"
#+msdos     "Windows"
#+unix      "Unix"
          )
        ; (text   (send text-item-proto :new 
        ;            (format nil "Close DataSheet and ~a ~a Data Object" 
        ;                    action name)))
         (text   (send text-item-proto :new 
                    (format nil "Close DataSheet and ~a Data" 
                            action name)))
         (file    (send toggle-item-proto 
                       :new (format nil "Also Save in ~a File" OS) 
                         :value t))
        
         (ok      (send modal-button-proto :new "OK"
                     :action #'(lambda ()
                                 (list t (send file :value)))))
         (discard (send modal-button-proto :new "Discard"
                        :action #'(lambda ()
                                    (list nil))))
         (cancel  (send modal-button-proto :new "Cancel"))
         (help (send modal-button-proto :new "Help"
                     :action #'(lambda () 
                                 (send self :close-help action os)
                                 (send self :close-dialog))))
         (dialog  (send modal-dialog-proto :new
                       ; (list text
                       ;      (list (list file (list ok cancel))
                       ;            (list help discard)))
                        (list text
                              file
                              (list ok discard)
                              (list cancel help))
                       :default-button OK))
         )
    (send dialog :modal-dialog)))

(defmeth datasheet-proto :close-help (action os)
  (let* ((whole-name (send (send self :data-object) :name))
         (message (display-window (format nil "The dialog buttons do the following:~2%OK closes the datasheet and uses its contents to ~a ~a ViSta data object. If the check box is checked, the data will also be saved in a ~a file. The file is specified in a second dialog box that follows the one currently on the screen.~2%DISCARD throws away the datasheet and all your changes.~2%CANCEL removes the dialog so you can continue editing the datasheet." (string-downcase action) whole-name os) 
           :title "Help: Close DataSheet" :show t :fit t :size '(300 100))))
        ))

(defmeth datasheet-proto :discard-changes ()
  (send self :discarded t)
  (send (send self :data-object) :datasheet-object nil)
  (send self :close-datasheet))

(defmeth datasheet-proto :close-datasheet ()
  (send self :hide-window)
  (cond
    ((send self :discarded)
     (apply #'send self :location (send self :location))
     (send self :discarded nil))
    (t
#-msdos(apply #'send self :location (send self :location))
;#+mdsos(apply #'send self :location (send self :frame-location))
#+msdos(apply #'send self :location (- (send self :location) '(4 24)))
     ))
  (send self :save-datasheet-arguments)
  (send self :remove) ;hide-window
  (send (send self :data-object) :datasheet-open nil)
  (send self :enable-vista-menus&tools t)
  (send self :help-menu-installed nil)
  (send self :showing nil)
  t)

(defmeth datasheet-proto :save-datasheet (&optional save-data closing)
  (when (not (equal *current-data* (send self :data-object)))
        (setcd (send self :data-object)))
  (let* ((result nil)
         (new-name nil)
         (dob (send self :data-object))
         (parents (send dob :dob-parents))
         (children (send dob :dob-children))
         (family (or parents children))
         (old-name (send dob :name))
         (dms (send self :data-matrix-strings))
         (num-choices 3)
         (table nil)
         (new-table nil)
         (types (mapcar #'string-capitalize (send self :type-strings)))
         (tok (list "Category" "Ordinal" "Numeric"))
         )
    (send self :type-strings types)
    (when family (setf num-choices 2))

    (cond
      ((and (send self :edited) (send self :editable) 
            (not (send self :new-data)))
       (if (= num-choices 2) (setf choice 0) (setf choice 2))
       (if (= choice 0) 
           (setf new-name (strcat "Ed-" old-name))
           (setf new-name old-name)))
      ((send self :new-data)     ;new data treated as update current dob
       (setf choice 2)
       (setf new-name old-name))
      ((or (not (send self :edited)) ;unedited or uneditable data discarded  
           (not (send self :editable)))
       (setf choice 1)))

    (when (not new-table) (setf new-table 1))
    (send self :save-datasheet-arguments)

    (when choice ;0=create new; 1=discard; 2=update current
          (when (/= 1 choice) ;use changes to create new or update current
                (send self :update-data-object choice new-name new-table)
                (cond
                  ((send current-data :matrices) (send *vista* :show-mats))
                  ((send current-data :ways) (send *vista* :show-cells))
                  (t (send *vista* :show-obs)))
                (send *vista* :show-labels))
          (when (< choice 2) ;leave old unchanged - discard or new
                (send self :nvar (- (send self :nvar) (send self :newvar)))
                (send self :nobs (- (send self :nobs) (send self :newobs)))
                (when (send self :nmat)
                      (send self :matrix-strings (send dob :matrices))
                      (send self :nmat (- (send self :nmat) 
                                          (send self :newmat))))
                (send self :variable-strings 
                                          (copy-list (send dob :variables)))
                (send self :type-strings  (copy-list (send dob :types)))
                (send self :create-label-strings dob)
                (send self :create-data-matrix-strings))
          (when (and (= choice 2) closing) (send self :close-datasheet))
          (send self :newvar 0)
          (send self :newobs 0)
          (send self :newmat 0)

          (when (and (= choice 0) save-data)
                (send *current-data* :about (send dob :about))
                (datasheet *current-data* :editable t
                           :show (not closing) 
                           :size (send self :size)
                           :location 
#+msdos                          (send self :frame-location)
#-msdos                          (send self :location)
                           :ndecimals (send self :number-of-decimals)
                           :ncolumns (send self :number-of-columns))
                (send self :close-datasheet)
                ))
    (send self :edited nil)
    (send self :new-data nil)
    choice))

(defmeth datasheet-proto :save-datasheet-arguments ()
  (send (send self :data-object) :datasheet-arguments
        (list (send self :size)
#+msdos       (send self :frame-location)
#-msdos       (send self :location)
              (send self :number-of-decimals)
              (send self :number-of-columns))))

(defmeth datasheet-proto :error-check ()
  (let* ((types (mapcar #'string-capitalize (send self :type-strings)))
         (tok (list "Category" "Ordinal" "Numeric"))
         (dms (send self :data-matrix-strings))
         )
    (dotimes (i (send self :nvar))
             (when (not (find (select types i) tok :test 'equal))
                   (vista-message 
                    "Variable types must be Category, Ordinal or Numeric. Data cannot be saved until this problem is fixed."
                    :location (send self :location))
                   (error "Bad Variable Type"))
             (when (not (equal (select types i) "Category"))
                   (map-elements #'convert-number-from-string (col dms i)
                                 self))
             )
    ))

(defun convert-number-from-string (str &optional dsob)
    (let ((result (ignore-errors (number-from-string str))))
      (when (not result) 
            (when (not (equal "nil" (string-downcase str)))
                  (vista-message 
          "A Numeric or Ordinal variable has values which are not numbers. The data cannot be saved until this problem is fixed. You must either make the values numbers, or make the variable type(s) Category."
                   :location (send dsob :location))
                  (error "Bad Numeric or Ordinal Data")))
      result))

(defmeth datasheet-proto :update-data-object (choice title table)
  (let* ((dob (send self :data-object))
         (matdata nil)
         (new-mat-names nil)
         (noldmat nil)
         (nnewmat nil)
         (dob-nvar (send dob :nvar))
         (dob-nobs (send dob :nobs))
         (dsob-nvar (send self :nvar))
         (dsob-nobs (send self :nobs)))
    (when (= choice 0) ;create new dob
          (cond
            ((send dob :matrices) 
             (data title
                   :created (send *desktop* :selected-icon)
                   :data (combine (send self :matrix-from-strings-matrix))
                   :variables (send self :variable-strings)
                   :matrices (send self :matrix-strings)
                   :labels (send self :label-strings)
                   :types (send self :type-strings)))
;if we could make a table dob here we wouldn't have to make both mv and tab
            (t
             (data title
                   :created (send *desktop* :selected-icon)
                   :data (combine (send self :matrix-from-strings-matrix))
                   :variables (send self :variable-strings)
                   :labels (send self :label-strings)
                   :types (send self :type-strings))))
          (when (= 0 table)
                (send current-data :make-table-data 
                      (first (send current-data :variables)))))
    (when (= choice 2) ;update old dob
          (cond 
            ((send dob :matrices) 
             (setf matdata (combine (send self :matrix-from-strings-matrix)))
             (send dob :matrices (send self :matrix-strings))
             (send dob :nmat (send self :nmat))
             (send dob :nele (/ (length matdata) (send dob :nmat)))
             (send dob :mat-states (repeat 'normal (send dob :nmat)))
             (send dob :shapes (repeat (first (send dob :shapes)) 
                                       (send dob :nmat)))
             (send dob :data (combine (transpose 
                (matrix (list (send dob :nmat) (send dob :nele)) matdata)))))
            (t
             (send dob :data (combine 
                              (send self :matrix-from-strings-matrix)))
             ))
          (send dob :labels (send self :label-strings))
          (send dob :variables (send self :variable-strings))
          (send dob :types (send self :type-strings))
          (when (or (/= dob-nvar dsob-nvar) (/= dob-nobs dsob-nobs))
                (send dob :nvar dsob-nvar)
                (send dob :nobs dsob-nobs)
                (send dob :obs-states (repeat 'normal dsob-nobs))
                (send dob :var-states (repeat 'normal dsob-nvar))))
    ))


(defmeth datasheet-proto :make-new-labels-and-cells ()
"Args: none
Used to write out edited table data.  Sorts table cell labels into order and makes a new table data cell list based on the sorted cell labels. Returns the sorted labels and the data cell list."
  (let* ((label-strings (send self :label-strings))
         (sorted-table (sort-and-permute-dob 
                        (send self :data-matrix-strings) 
                        label-strings label-strings nil))
         (sorted-data   (combine (first sorted-table)))
         (sorted-labels (second sorted-table))
         (nobs (length sorted-labels))
         (data-cell-list nil)
         (start 0)
         (finish nil)) 
    (dotimes (i (1- nobs))
       (when (not (eq (select sorted-labels i) (select sorted-labels (1+ i))))
             (setf finish i)
             (setf data-cell-list (add-element-to-list 
                                   data-cell-list 
                                  (select sorted-data (iseq start finish))))
             (setf start (1+ i))))
    (setf data-cell-list (add-element-to-list 
                          data-cell-list 
                         (select sorted-data (iseq start (1- nobs)))))
    (list sorted-labels data-cell-list)))
             
(defmeth datasheet-proto :matrix-from-strings-matrix () 
  (let* ((dob  current-data)
         (dms  (send self :data-matrix-strings))
         (type (send self :type-strings))
         (nvar (send self :nvar))
         (nobs (send self :nobs))
         (dm   nil))
     (dotimes (i nvar)
              (cond 
                ((equal (select type i) "Category")
                 (setf dm (combine dm (col dms i))))
                (t
                 (setf dm (combine dm
                     (map-elements #'number-from-string (col dms i)))))))
    (transpose (matrix (list nvar nobs) (rest dm)))))

(defmeth datasheet-proto :show-window () 
  (send (send self :data-object) :datasheet-open t)
  (send self :showing t)
  (call-next-method))

(defmeth datasheet-proto :hide-window () 
  (send (send self :data-object) :datasheet-open nil)
  (send self :showing nil)
  (call-next-method))

(defmeth datasheet-proto :set-fw-dialog () 
  (let* ((min-ncols 1)
         (tw        (send self :text-width "9"))
         (signw     (send self :text-width "-"))
         (dcimlw    (send self :text-width "."))
         (ndecimals (send self :number-of-decimals))
         (old-ncols (send self :number-of-columns))
         (new-ncols (get-value-dialog "Width of Columns:" 
                                      :initial old-ncols))
         )
    (when new-ncols 
          (when (not new-ncols) (setf new-ncols (list min-ncols)))
          (when (not (first new-ncols)) (setf new-ncols (list min-ncols)))
          (when (< (first new-ncols) min-ncols) 
                (setf new-ncols (list min-ncols)))
          (send self :field-width (+ (* tw (first new-ncols)) dcimlw signw 6))
          (send self :number-of-columns (first new-ncols))
          (send self :scroll 0 0)
          (send self :has-h-scroll 
                (max (select (screen-size) 0)
                     (+ 1 (send self :label-width) (* (send self :field-width) 
                                           (+ 1 (send self :nvar))))))
          (send self :redraw)))
  (send self :save-datasheet-arguments))

(defmeth datasheet-proto :set-dec-dialog ()
  (let* ((odec (send self :number-of-decimals))
         (ndec (get-value-dialog "Number of Decimals:" 
                                 :initial odec))) 
    (when ndec
          (setf ndec (first ndec))
          (when (not ndec) (setf ndec odec))
          (when (< ndec 0) (setf ndec odec))
          (send self :number-of-decimals ndec)
          (send self :create-data-matrix-strings)
          (send self :redraw)))
  (send self :save-datasheet-arguments))

(setf *datasheet* nil)