/*
 * nasd_linux_edrfs_fm_colocate.c
 *
 * NASD-EDRFS File Manger Linux Kernel Module
 *
 * Authors: Marc Unangst, Jim Zelenka, Sean Levy
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#include <nasd/nasd_options.h>

#if defined(LINUX) && defined(KERNEL) && defined(MODULE) /* should always be */

#include <linux/module.h>
#include <nasd/nasd_sys.h>
#include <nasd/nasd_edrfs_client_colocate.h>

#define NASD_EXPORT_SYMBOL(_symname_) EXPORT_SYMBOL(_symname_)

#include <nasd/nasd_linux_edrfs_fm_syms.ver.h>

MODULE_AUTHOR("Marc Unangst <mju+@cs.cmu.edu>");
MODULE_DESCRIPTION("NASD-EDRFS File Manager");

extern int nasd_edrfs_srv_go(nasd_edrfs_svinfo_t *);

/*
 * Yes, incrementing the mod count here means that if the drive
 * crashes, you can't unload the module. If we didn't, when the
 * drive crashed, unloading the module would hang the kernel.
 * ("Experimental evidence"). So don't bother trying.
 */

void
nasd_linux_edrfs_fm_module_start()
{
  MOD_INC_USE_COUNT;
}

void
nasd_linux_edrfs_fm_module_stop()
{
  MOD_DEC_USE_COUNT;
}

nasd_status_t
nasd_edrfscli_colocate_linux_bind(
  nasd_edrfs_handle_t   handle,
  char                 *server_name,
  char                 *portnum,
  int                   binding_type,
  void                 *binding_param,
  int                   binding_param_len)
{
  MOD_INC_USE_COUNT;
  return(NASD_SUCCESS);
}

nasd_status_t
nasd_edrfscli_colocate_linux_unbind(
  nasd_edrfs_handle_t  handle)
{
  MOD_DEC_USE_COUNT;
  return(NASD_SUCCESS);
}

nasd_edrfscli_rpcmod_tab_t nasd_edrfscli_colocate_linux_mod = {
  NULL,
  NASD_RPCMOD_INIT_FAIL,

  nasd_edrfscli_colocate_linux_bind,
  nasd_edrfscli_colocate_linux_unbind,

  nasd_edrfscli_colocate_null,
  nasd_edrfscli_colocate_mount,
  nasd_edrfscli_colocate_fsstat,
  nasd_edrfscli_colocate_fsinfo,
  nasd_edrfscli_colocate_lookup,
  nasd_edrfscli_colocate_readdir,
  nasd_edrfscli_colocate_access,
  nasd_edrfscli_colocate_setattr,
  nasd_edrfscli_colocate_create,
  nasd_edrfscli_colocate_symlink,
  nasd_edrfscli_colocate_remove,
  nasd_edrfscli_colocate_mkdir,
  nasd_edrfscli_colocate_rmdir,
  nasd_edrfscli_colocate_newcookie,
  nasd_edrfscli_colocate_rename,
  nasd_edrfscli_colocate_getstats,
  nasd_edrfscli_colocate_resetstats,

  nasd_edrfscli_colocate_lookup_otw_provided,
  nasd_edrfscli_colocate_create_otw_provided,

  nasd_edrfscli_colocate_error_string,

  NASD_BIND_COLOCATE,
  "Colocated",
  0,

  NULL
};

void
nasd_edrfscli_colocate_linux_register()
{
  nasd_edrfscli_mod_register(&nasd_edrfscli_colocate_linux_mod, 0);
}

void
nasd_edrfscli_colocate_linux_unregister()
{
  nasd_edrfscli_mod_unregister(&nasd_edrfscli_colocate_linux_mod, 0);
}

int
init_module()
{
  nasd_linux_set_edrfs_launch(nasd_edrfs_srv_go);
  nasd_edrfscli_colocate_linux_register();
  return(0);
}

void
cleanup_module()
{
  nasd_edrfscli_colocate_linux_unregister();
  nasd_linux_set_edrfs_launch(NULL);
}

#endif /* LINUX && KERNEL && MODULE */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
