/*
 * nasd_varargs.h
 *
 * Definitions for varargs in NASD
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_VARARGS_H_
#define _NASD__NASD_VARARGS_H_

#if NASD_USE_OLD_VARARGS > 0
#include <varargs.h>

#define NASD_VARARGS_PROTO(_expr_)

typedef va_list nasd_valist_t;

#define NASD_VARARG_START(_valist_,_firstarg_)  va_start(_valist_)
#define NASD_VARARG_END(_valist_)               va_end(_valist_)

#else /* NASD_USE_OLD_VARARGS > 0 */
#include <stdarg.h>

#define NASD_VARARGS_PROTO(_expr_) _expr_

typedef va_list nasd_valist_t;

#define NASD_VARARG_START(_valist_,_firstarg_)  va_start(_valist_,_firstarg_)
#define NASD_VARARG_END(_valist_)               va_end(_valist_)

#endif /* NASD_USE_OLD_VARARGS > 0 */

#endif /* !_NASD__NASD_VARARGS_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
