/*
 * nasd_shell_internal.h
 *
 * NASD-shell definitions internal to shell core
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_SHELL_INTERNAL_H_
#define _NASD__NASD_SHELL_INTERNAL_H_

#include <nasd/nasd_options.h>
#include <nasd/nasd_shell.h>

typedef struct nasd_shell_hash_s          nasd_shell_hash_t;
typedef struct nasd_shell_hash_ent_s      nasd_shell_hash_ent_t;
typedef struct nasd_shell_hashkey_rock_s  nasd_shell_hashkey_rock_t;
typedef struct nasd_shell_module_s        nasd_shell_module_t;

extern nasd_shutdown_list_t *nasd_shell_shutdown_list;

#define NASD_SHELL_HASH_KEY_BOGUS    0
#define NASD_SHELL_HASH_KEY_STATIC   1
#define NASD_SHELL_HASH_KEY_DYNAMIC  2
#define NASD_SHELL_HASH_KEY_ROCKED   3

#define NASD_SHELL_HASH_KEY_ROCK_LEN 128

struct nasd_shell_hashkey_rock_s {
  char                        key[NASD_SHELL_HASH_KEY_ROCK_LEN];
  nasd_shell_hashkey_rock_t  *next;
};

struct nasd_shell_hash_ent_s {
  char                       *key;
  int                         key_type;
  int                         key_len;
  nasd_shell_hashkey_rock_t  *key_rock;
  void                       *data;
  nasd_shell_hash_ent_t      *next;
  nasd_shell_hash_ent_t      *prev;
};

struct nasd_shell_hash_s {
  int                     nbuckets;
  nasd_shell_hash_ent_t  *buckets;
};

struct nasd_shell_module_s {
  char                 *name;
  nasd_shell_module_t  *hnext;
  nasd_shell_module_t  *hprev;
};

extern char *nasd_shell_prompt;
extern int nasd_shell_prompt_len;

#define NASD_SHELL_PROMPT_DEFAULT "% "

extern void nasd_shell_init_primitives(void);
extern void nasd_shell_init_interactive(void);
extern void nasd_shell_interact(void);

extern void nasd_shell_hash_init(void);
extern void nasd_shell_hash_destroy(nasd_shell_hash_t *hash);
extern nasd_status_t nasd_shell_hash_create(nasd_shell_hash_t **hashp,
  int nbuckets);

#endif /* !_NASD__NASD_SHELL_INTERNAL_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */

