/*
 * nasd_options.h
 *
 * All NASD source files (not just .c files) should #include this
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_OPTIONS_H_
#define _NASD__NASD_OPTIONS_H_

/* ---------- Security options ---------- */

/* Set to 1 to enable security.  This can be overridden by itomf.  */
#ifndef NASD_SECURE_RPCS_ENABLE
#define NASD_SECURE_RPCS_ENABLE  0
#endif /* !NASD_SECURE_RPCS_ENABLE */

/* Print a warning message when a security error (including
   invalid/rejected authentication) is encountered. */
#define NASD_SECURITY_DEBUG_ERRORS 1

/* Calculate message digests for calls through the colocation
   interface.  Mainly for numbers-taking so the colocation interface's
   performance is "fairer" to the RPC layers.  If this is turned off,
   the drive just compares keys to verify the authenticity of the
   request. */
#define NASD_COLOCATE_CALC_DIGESTS 0

/* Set to 1 to keep/print statistics about time spent doing encryption
   and digesting. */
#define NASD_SECURITY_KEEP_STATS  0
#define NASD_SECURITY_PRINT_STATS 0

/* Set to 1 to use glibc2's malloc tracing feature; this can help find
   malloc problems even in parts of the code that don't use the NASD
   malloc and free primitives. */
#define NASD_USE_GLIBC_MALLOC_TRACING 0

/* ---------- Marshalling options ---------- */
/* Setting this nonzero forces the _otw_t types to be 8-byte aligned,
   which allows us to generate faster marshalling code.  */
#define NASD_ALIGN_OTW_TYPES 1

/* ---------- Debugging options ---------- */
/* debug atomic ops (locks, etc) */
#define NASD_DEBUG_ATOMIC 0

#if defined(LINUX) && defined(KERNEL) && NASD_DEBUG_ATOMIC
ERROR in nasd_options.h.  NASD_DEBUG_ATOMIC does not currently work 
inside the linux kernel 
#endif /* defined(LINUX) && defined(KERNEL) && NASD_DEBUG_ATOMIC */

/* show shutdown tasks as they occur */
#define NASD_DEBUG_SHUTDOWN 1

/* track outstanding memory allocation count */
#define NASD_MEM_COUNT_ALLOC 1

/* print freelist statistics during shutdown */
#define NASD_FREELIST_STATS 0

/* find core leaks -- EXPENSIVE */
#define NASD_TRACK_ALLOCATIONS 0

/* EDRFS keep stats on cache ops */
#define NASD_EDRFS_KEEP_CACHE_STATS 1

/* EDRFS report cache ops stats */
#define NASD_EDRFS_DUMP_CACHE_STATS 0

/* include testing scaffold for common API elements */
#define NASD_COMMON_TEST 1

/* include testing scaffold for timing mechanism */
#define NASD_TIMEOUT_TEST 0

/*
 * Set this value >=3 to attempt to detect corruption by array
 * over or underwrites.
 */
#define NASD_MEM_FENCEPOST 0

/*
 * Set this to a 32-bit fill pattern, eg 0xdeadbeef
 */
#define NASD_MEM_FILL 0


/* 
 * Set this to 1 to turn calls breakpoint into panics (to assist in ferreting them out)
 */
#define NASD_BREAKPOINT_IS_PANIC 0

/* ---------- RPC options ---------- */
/*
 * !!! Keep these values synchronized with:
 *   itomf, NASD.rpc_types, nasd_options.h
 */
#define NASD_RPC_PACKAGE_DCE  1
#define NASD_RPC_PACKAGE_SRPC 2
#define NASD_RPC_PACKAGE_NONE 3

/*
 * Default RPC package. This is overridden by itomf.
 * If you change this, you will break the dux compile process.
 */
#ifndef NASD_RPC_PACKAGE
#define NASD_RPC_PACKAGE NASD_RPC_PACKAGE_DCE
#endif /* !NASD_RPC_PACKAGE */

/* ---------- Miscellaneous ---------- */
/* You shouldn't have to change anything below here. */
#if defined(MACH) && defined(OSF) && defined(KERNEL)
#define DEC_OSF        1
#ifdef ASSEMBLER
#ifdef __LANGUAGE_C__
#undef __LANGUAGE_C__
#endif /* __LANGUAGE_C__ */
#else /* ASSEMBLER */
#define __LANGUAGE_C__ 1
#endif /* ASSEMBLER */
#endif /* MACH && OSF && KERNEL */

#if defined(__alpha) && defined(__osf__)
#ifndef DEC_OSF
#define DEC_OSF 1
#endif /* !DEC_OSF */
#endif /* __alpha && __osf__ */

#ifdef __linux__
#ifndef LINUX
#define LINUX 1
#endif /* !LINUX */
#endif /* __linux__ */

#if defined(VXWORKS)
#define NASD_WIND_THREADS 1
#endif /* VXWORKS */

#if 0
#define db_printf(_a_) nasd_printf _a_
#else
#define db_printf(_a_) { /* noop */ }
#endif

#ifdef KERNEL

#ifdef DEC_OSF
#include <nasdpd.h>
#define NASD_NUM_KPDEV NNASDPD
#else /* DEC_OSF */
#define NASD_NUM_KPDEV 16
#endif /* DEC_OSF */

#endif /* KERNEL */

#ifdef i386
#ifndef __i386__
#define __i386__
#endif /* !__i386__ */
#endif /* i386 */

#ifdef __i386__
#ifndef i386
#define i386
#endif /* !i386 */
#endif /* __i386__ */

#include <nasd/nasd_site.h>

#endif /* !_NASD__NASD_OPTIONS_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
