/*
 * nasd_common.h
 *
 * shared header file for NASD entities - basic
 * prototypes for library functions
 *
 * Authors: Jim Zelenka, Howard Gobioff
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_COMMON_H_
#define _NASD__NASD_COMMON_H_

#include <nasd/nasd_options.h>
#include <nasd/nasd_itypes.h>
#include <nasd/nasd_types.h>
#include <nasd/nasd_error.h>
#if !defined(LINUX) || (defined(LINUX) && !defined(KERNEL))
#include <sys/time.h>
#endif /* !LINUX || (LINUX && !KERNEL) */

#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE
#include <dce/dce_error.h>
#include <dce/rpc.h>
#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE */

#ifdef SOLARIS
#include <nasd/solaris/nasd_solaris_common.h>
#endif /* SOLARIS */

#ifdef IRIX
#include <nasd/irix/nasd_irix_common.h>
#endif /* IRIX */

#ifdef FREEBSD
#include <nasd/freebsd/nasd_freebsd_common.h>
#endif /* FREEBSD */

extern char *nasd_error_string(nasd_status_t err);
extern void nasd_printstat(nasd_attribute_t *attr);
extern nasd_status_t nasd_str_to_nasd_id(char *str,
  nasd_identifier_t *nidp);

extern void nasd_gettime(nasd_timespec_t *tm);
extern nasd_status_t nasd_sys_init(void);
extern void nasd_sys_shutdown(void);
extern nasd_status_t nasd_get_clock_speed(nasd_uint64 *ticksp);

extern void nasd_delay_ts(nasd_timespec_t ts);

extern nasd_status_t nasd_inet_aton(char *hostname, nasd_uint32 *addrp);
extern nasd_status_t nasd_inet_svcton(char *portname, nasd_uint16 *ipport);

extern char *_nasd_timestr(time_t t);
extern char *_nasd_timestr_r(time_t, char *);
extern char *nasd_timestr_r(nasd_timespec_t ts, char *str);

extern void nasd_debug_breakpoint();

nasd_status_t nasd_hostlocal(char *hostname);

#ifndef KERNEL
#include <netdb.h>

nasd_status_t nasd_gethostbyname_r(char *hostname, struct hostent *hep);
nasd_status_t nasd_raw_disk_len(int fd, nasd_uint64 *lenp);
nasd_uint64 nasd_lseek(int fd, nasd_uint64 offset, int whence, int *err);
#endif /* !KERNEL */

#if NASD_IDLE_SUPPORT > 0
extern nasd_status_t nasd_get_total_idle_time(nasd_timespec_t *ts);
#endif /* NASD_IDLE_SUPPORT > 0 */

#ifdef DEC_OSF
#include <nasd/dux/nasd_dux_common.h>
#endif /* DEC_OSF */

#ifdef LINUX
#include <nasd/linux/nasd_linux_common.h>
#endif /* LINUX */

#if NASD_COMMON_TEST > 0
extern nasd_status_t nasd_atomic_test(void);
#else /* NASD_COMMON_TEST > 0 */
#define nasd_atomic_test()  NASD_OP_NOT_SUPPORTED
#endif /* NASD_COMMON_TEST > 0 */

extern nasd_status_t nasd_kernel_atomic_test(void);

extern nasd_status_t nasd_check_mem_list(nasd_mem_list_t *memlist);
extern void nasd_free_mem_list(nasd_mem_list_t *src);
extern nasd_status_t nasd_dup_mem_list(nasd_mem_list_t *src,
                                       nasd_mem_list_t **dst);

#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE

/*
 * DCE-direct binding stuff
 */

extern nasd_status_t nasd_dce_direct_bind_to_server(
  unsigned_char_t *protseq, unsigned_char_t *host,
  unsigned_char_t *endpoint, rpc_binding_handle_t *binding_handle);

extern nasd_status_t nasd_dce_direct_unbind_server(
  rpc_binding_handle_t *binding_handle);

#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE */

#endif /* !_NASD__NASD_COMMON_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
