/*
 * nasd_cheops_common.h
 *
 * Common CHEOPS definitions
 *
 * Author: Khalil Amiri, CMU SCS/ECE, July 18 1997
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD_CHEOPS_COMMON_H_
#define _NASD_CHEOPS_COMMON_H_

#include <nasd/nasd_options.h>
#include <stdio.h>
#include <malloc.h>
#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE
# include <dce/dce_error.h>
#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE */
#include <nasd/nasd_types.h>
#include <nasd/nasd_mem.h>
#include <nasd/nasd_pdrive_client.h>
#include <nasd/nasd_threadstuff.h>
#include <nasd/nasd_cheops_types.h>
#include <nasd/nasd_cheops_client.h>

#ifdef KERNEL

#define cheops_Msg			nasd_printf)(

#else /* KERNEL */

#ifdef CHEOPS_PRINT_ERROR 
#define       cheops_Msg                     fprintf)(stderr,
#else /* CHEOPS_PRINT_ERROR */
#define	      cheops_Msg		          fprintf)(stderr,
#endif /* CHEOPS_PRINT ERROR */

#ifndef TRUE
#define TRUE (1)
#define FALSE (0)
#endif /* TRUE */

#endif /* KERNEL */

typedef char *_nasd_cheops_buffer_t;

/* cheops object attributes */
typedef struct _nasd_cheops_attribute_s {
  nasd_uint32                   block_size; /* 4 bytes */
  nasd_uint64                   object_len; /* 8 bytes */
  nasd_cheops_raid_level_t      raid_level;  /* 4 bytes */
  nasd_identifier_t             ni[NASD_CHEOPS_MAX_STRIPE_SIZE]; /* 64 bytes */
  nasd_disk_ident_t             di[NASD_CHEOPS_MAX_STRIPE_SIZE]; /* 64 bytes */
  nasd_timespec_t               attr_modify_time; /* 8 bytes */
  nasd_timespec_t               object_modify_time; /* 8 bytes */
  nasd_timespec_t               object_create_time; /* 8 bytes */         
} _nasd_cheops_attribute_t;
  
/* cheops drive handle */
typedef struct _nasd_cheops_dr_handle_s {
  int                           dr_id;
  int                           partnum;
  char                          dr_name[NASD_CHEOPS_DR_NAMELEN];
  char                          dr_port[NASD_CHEOPS_DR_NAMELEN];
  int                           binding_type;
  nasd_drive_handle_t           h;   /* communication handle - userland rpcs */
  int                           fd;  /* fd for kernel pseudodev/kernel rpcs */
} _nasd_cheops_dr_handle_t;

/* cheops storage manager handle */
typedef struct _nasd_cheops_mgr_handle_s {
  int                            mgr_id;
  char                          *mgr_name;
  char                          *mgr_port;
  nasd_cheops_handle_t           h;
} _nasd_cheops_mgr_handle_t;

typedef struct _nasd_cheops_mgr_handles_s {
  int                            num_managers;
  _nasd_cheops_mgr_handle_t     *hl;
} _nasd_cheops_mgr_handles_t;

#define MAX_NUM_MANAGERS                        8
#define MAX_NUM_DRIVES                          16
	
/* error codes */
#define _NASD_CHEOPS_ERR_INIT_FAILED            5000
#define _NASD_CHEOPS_ERR_CANT_CREATE_FILE       5001
#define _NASD_CHEOPS_ERR_ISEMPTY                5002
#define _NASD_CHEOPS_ERR_ISLOCKED               5003
#define _NASD_CHEOPS_ERR_NOTFOUND               5004
#define _NASD_CHEOPS_ERR_READFAILED             5005
#define _NASD_CHEOPS_ERR_READINCOMP             5006
#define _NASD_CHEOPS_ERR_WRITEFAILED            5007
#define _NASD_CHEOPS_ERR_WRITEINCOMP            5008
#define _NASD_CHEOPS_ERR_DOESNOTEXIST           5009

/* utility routines */
char *nasd_cheops_walk_str(char **);

#endif /* !_NASD_CHEOPS_COMMON_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
