/*
 * nasd_dux_sys.h
 *
 * Dux-specific defines for system interface
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_DUX_SYS_H_
#define _NASD__NASD_DUX_SYS_H_

#include <sys/errno.h>
#include <sys/ioctl.h>
#include <sys/param.h>

typedef dev_t nasd_sys_dev_t;

#ifdef KERNEL

extern lock_data_t nasd_d_lock;
extern struct lockinfo *nasd_d_lockinfo;

#define NASD_D_LOCK()        lock_write(&nasd_d_lock)
#define NASD_D_READ_LOCK()   lock_read(&nasd_d_lock)
#define NASD_D_UNLOCK()      lock_done(&nasd_d_lock)
#define NASD_D_LOCK_INIT()   lock_setup(&nasd_d_lock,nasd_d_lockinfo,TRUE)
#define NASD_D_LOCK_HOLDER() (LOCK_HOLDER(&nasd_d_lock))

#define nasd_sys_copyin(_src_,_dst_,_len_) \
  copyin(_src_, _dst_, _len_)

#define nasd_sys_copyout(_src_,_dst_,_len_) \
  copyout(_src_, _dst_, _len_)

#endif /* KERNEL */

#endif /* !_NASD__NASD_DUX_SYS_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
