/*
 * nasd_dux_kernel_drive.h
 *
 * Digital Unix specific drive code
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_DUX_KERNEL_DRIVE_H_
#define _NASD__NASD_DUX_KERNEL_DRIVE_H_

#include <vm/vm_page.h>
#include <kern/lock.h>

/*
 * Maximum number _possible_- actual limit is nasd_drive_io_max_coalesce.
 */
#define NASD_IO_MAX_COALESCE 128 /* XXX is this right? */

#define nasd_odc_io_ent_swap_bufs(_ent1_,_ent2_) { \
  vm_page_t _tmp_pp; \
  void  *_tmp_buf; \
  _tmp_buf = (_ent1_)->data.buf; \
  _tmp_pp = (_ent1_)->pp; \
  (_ent1_)->data.buf = (_ent2_)->data.buf; \
  (_ent1_)->pp = (_ent2_)->pp; \
  (_ent2_)->data.buf = _tmp_buf; \
  (_ent2_)->pp = _tmp_pp; \
}

#define NASD_ODC_IO_ENT_CLEAR_PAGE(_ent_) { \
  (_ent_)->data.buf = NULL; \
  (_ent_)->pp = VM_PAGE_NULL; \
}

#define NASD_ODC_IO_ENT_ASSERT_NO_PAGE(_ent_) { \
  NASD_ASSERT((_ent_)->data.buf == NULL); \
  NASD_ASSERT((_ent_)->pp == VM_PAGE_NULL); \
}

/*
 * from nasd_od_kio.c
 */
nasd_status_t nasd_od_k_init(nasd_od_config_t *config);
void nasd_od_k_iodone(struct buf *bp);
nasd_status_t nasd_od_k_blkio(nasd_odc_ent_t *ent, nasd_blkno_t sectno,
  void *buf, int len, int iodir);
nasd_status_t nasd_od_k_blkio_cb(nasd_odc_ent_t *ent, nasd_blkno_t sectno,
  void *buf, int len, int iodir, void (*cb)(void *), void *arg);
nasd_status_t nasd_od_k_write_header(nasd_odc_ent_t *fake_ent,
  nasd_blkno_t sectno, nasd_od_disk_t *disk);
void nasd_psrv_thread(nasd_threadarg_t arg);
int nasd_psrv_go(nasd_svinfo_t *svinfo);
void nasd_od_k_finish_flush(struct buf *bp);
nasd_status_t nasd_od_io_launch_internal(nasd_odc_ent_t *entlist);

#endif /* !_NASD__NASD_DUX_KERNEL_DRIVE_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
