/*
 * nasd_edrfs_test.h
 *
 * Internal definitions for the NASD EDRFS test library
 *
 * Author: Mathew Monroe
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD_EDRFS_TEST_H_
#define _NASD_EDRFS_TEST_H_

#include <nasd/nasd_options.h>
#include <nasd/nasd_common.h>
#include <nasd/nasd_error.h>
#include <nasd/nasd_mem.h>
#include <nasd/nasd_pdrive_client.h>
#include <nasd/nasd_edrfs_client.h>

typedef struct nasd_edrfs_test_funct_s {
  char *name, *usage;
  nasd_status_t (*marshall) (int argc, char *argv[], void **args);
  nasd_status_t (*test) (nasd_edrfs_handle_t handle, void *args, void **res,
			 nasd_rpc_status_t *op_status);
  nasd_status_t (*printres) (void *res);
  nasd_status_t (*cleanup) (void *args, void *res);
} nasd_edrfs_test_funct_t;


/*
 * Every type of function will generally have these, so we make a nice
 * macro once again.
 */

#define NASD_EDRFS_TEST_PREDECL_FUNCTS(_T_)  nasd_status_t \
nasd_edrfs_test_ ## _T_ ## _marshall(int, char *[], void **); \
nasd_status_t nasd_edrfs_test_ ## _T_ ## _test(nasd_edrfs_handle_t, void*, \
					     void **, nasd_rpc_status_t *); \
nasd_status_t nasd_edrfs_test_ ## _T_ ## _printres(void *); \
nasd_status_t nasd_edrfs_test_ ## _T_ ## _cleanup(void *, void *); \

/*
 * Mount
 */

NASD_EDRFS_TEST_PREDECL_FUNCTS(mount)

#define NASD_EDRFS_TEST_FUNCT_MOUNT { "mount", "pathname", \
  nasd_edrfs_test_mount_marshall, nasd_edrfs_test_mount_test, \
  nasd_edrfs_test_mount_printres, nasd_edrfs_test_mount_cleanup \
  }

/*
 * Null
 */

nasd_status_t nasd_edrfs_test_null_test(nasd_edrfs_handle_t, void *, void **,
				      nasd_rpc_status_t *);

#define NASD_EDRFS_TEST_FUNCT_NULL { "null", "", \
  NULL, nasd_edrfs_test_null_test, NULL, NULL }

/*
 * Fsstat
 */

NASD_EDRFS_TEST_PREDECL_FUNCTS(fsstat)

#define NASD_EDRFS_TEST_FUNCT_FSSTAT { "fsstat", "identifier", \
  nasd_edrfs_test_fsstat_marshall, nasd_edrfs_test_fsstat_test, \
  nasd_edrfs_test_fsstat_printres, nasd_edrfs_test_fsstat_cleanup \
  }

/*
 * Fsinfo
 */

NASD_EDRFS_TEST_PREDECL_FUNCTS(fsinfo)

#define NASD_EDRFS_TEST_FUNCT_FSINFO { "fsinfo", "identifier", \
  nasd_edrfs_test_fsinfo_marshall, nasd_edrfs_test_fsinfo_test, \
  nasd_edrfs_test_fsinfo_printres, nasd_edrfs_test_fsinfo_cleanup \
  }

/*
 * Lookup
 */

NASD_EDRFS_TEST_PREDECL_FUNCTS(lookup)

#define NASD_EDRFS_TEST_FUNCT_LOOKUP { "lookup", "identifier name", \
  nasd_edrfs_test_lookup_marshall, nasd_edrfs_test_lookup_test, \
  nasd_edrfs_test_lookup_printres, nasd_edrfs_test_lookup_cleanup \
  }

/*
 * Readdir
 */

NASD_EDRFS_TEST_PREDECL_FUNCTS(readdir)

#define NASD_EDRFS_TEST_FUNCT_READDIR { "readdir", \
  "identifier mark markverf count", \
  nasd_edrfs_test_readdir_marshall, nasd_edrfs_test_readdir_test, \
  nasd_edrfs_test_readdir_printres, nasd_edrfs_test_readdir_cleanup \
  }

/*
 * Access
 */

NASD_EDRFS_TEST_PREDECL_FUNCTS(access)

#define NASD_EDRFS_TEST_FUNCT_ACCESS { "access", \
  "identifier access", \
  nasd_edrfs_test_access_marshall, nasd_edrfs_test_access_test, \
  nasd_edrfs_test_access_printres, nasd_edrfs_test_access_cleanup \
  }

/*
 * Create
 */

NASD_EDRFS_TEST_PREDECL_FUNCTS(create)

#define NASD_EDRFS_TEST_FUNCT_CREATE { "create", \
  "directory_id name fieldmask", \
  nasd_edrfs_test_create_marshall, nasd_edrfs_test_create_test, \
  nasd_edrfs_test_create_printres, nasd_edrfs_test_create_cleanup \
  }

/*
 * Setattr
 */

NASD_EDRFS_TEST_PREDECL_FUNCTS(setattr)

#define NASD_EDRFS_TEST_FUNCT_SETATTR { "setattr", \
  "identifier fieldmask uid gid mode size", \
  nasd_edrfs_test_setattr_marshall, nasd_edrfs_test_setattr_test, \
  nasd_edrfs_test_setattr_printres, nasd_edrfs_test_setattr_cleanup \
  }


/*
 * Symlink
 */

NASD_EDRFS_TEST_PREDECL_FUNCTS(symlink)

#define NASD_EDRFS_TEST_FUNCT_SYMLINK { "symlink", \
  "directory_id dirpath symlink uid gid mode", \
  nasd_edrfs_test_symlink_marshall, nasd_edrfs_test_symlink_test, \
  nasd_edrfs_test_symlink_printres, nasd_edrfs_test_symlink_cleanup \
  }


/*
 * Rename
 */

NASD_EDRFS_TEST_PREDECL_FUNCTS(rename)

#define NASD_EDRFS_TEST_FUNCT_RENAME { "rename", \
  "from_directory_id to_directory_id from_path to_path", \
  nasd_edrfs_test_rename_marshall, nasd_edrfs_test_rename_test, \
  nasd_edrfs_test_rename_printres, nasd_edrfs_test_rename_cleanup \
  }


/*
 * Remove
 */

NASD_EDRFS_TEST_PREDECL_FUNCTS(remove)

#define NASD_EDRFS_TEST_FUNCT_REMOVE { "remove", \
  "directory_id path", \
  nasd_edrfs_test_remove_marshall, nasd_edrfs_test_remove_test, \
  NULL, nasd_edrfs_test_remove_cleanup \
  }


/*
 * Mkdir
 */

NASD_EDRFS_TEST_PREDECL_FUNCTS(mkdir)

#define NASD_EDRFS_TEST_FUNCT_MKDIR { "mkdir", \
  "directory_id path fieldmask uid gid mode", \
  nasd_edrfs_test_mkdir_marshall, nasd_edrfs_test_mkdir_test, \
  nasd_edrfs_test_mkdir_printres, nasd_edrfs_test_mkdir_cleanup \
  }


/*
 * Rmdir
 */

NASD_EDRFS_TEST_PREDECL_FUNCTS(rmdir)

#define NASD_EDRFS_TEST_FUNCT_RMDIR { "rmdir", \
  "directory_id path", \
  nasd_edrfs_test_rmdir_marshall, nasd_edrfs_test_rmdir_test, \
  NULL, nasd_edrfs_test_rmdir_cleanup \
  }


/*
 * Newcookie
 */

NASD_EDRFS_TEST_PREDECL_FUNCTS(newcookie)

#define NASD_EDRFS_TEST_FUNCT_NEWCOOKIE { "newcookie", \
  "", \
  nasd_edrfs_test_newcookie_marshall, nasd_edrfs_test_newcookie_test, \
  nasd_edrfs_test_newcookie_printres, nasd_edrfs_test_newcookie_cleanup \
  }


/*
 * Getstats
 */

NASD_EDRFS_TEST_PREDECL_FUNCTS(getstats)

#define NASD_EDRFS_TEST_FUNCT_GETSTATS { "getstats", \
  "", \
  NULL, nasd_edrfs_test_getstats_test, \
  nasd_edrfs_test_getstats_printres, nasd_edrfs_test_getstats_cleanup \
  }


#endif /* !_NASD_EDRFS_TEST_H_ */
