/*
 * decompose.c
 *
 * Decompose a NASD identifier.
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */

#include <nasd/nasd_options.h>
#include <nasd/nasd_types.h>
#include <nasd/nasd_freelist.h>
#include <nasd/nasd_itypes.h>
#include <nasd/nasd_mem.h>
#include <nasd/nasd_cache.h>
#include <nasd/nasd_common.h>

char *progname;

void
usage()
{
  fprintf(stderr, "USAGE: %s nasd_identifier\n", progname);
  fflush(stderr);
  exit(1);
}

int
main(
  int     argc,
  char  **argv)
{
  nasd_nodenum_t nodenum;
  nasd_identifier_t nid;
  nasd_generation_t gen;
  nasd_blkno_t hint;
  nasd_status_t rc;
  int partnum;

  progname = argv[0];

  if (argc != 2)
    usage();

  rc = nasd_str_to_nasd_id(argv[1], &nid);
  if (rc)
    usage();

  rc = nasd_od_decompose_id(nid, &partnum, &nodenum, &hint, &gen);
  if (rc) {
    fprintf(stderr, "ERROR: got status=%lu (%s) from nasd_od_decompose_id()\n",
      (unsigned long)rc, nasd_error_string(rc));
    fflush(stderr);
    exit(1);
  }

  printf("Partition %d  Node %d  Hinted block %u  Generation %d\n",
    (int)partnum, (int)nodenum, (unsigned int)hint, (int)gen);
  fflush(stdout);

  exit(0);
}

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
