/*
 * nasd_vx_incstat.c
 *
 * Increment nasd statistic word under VxWorks
 *
 * Author: Marc Unangst
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#include <taskLib.h>

#include <nasd/nasd_options.h>
#include <nasd/nasd_types.h>

/* Atomically increment a 64-bit word. */
void
nasd_atomic_inc64(nasd_int64 i)
{
  /* might need intLock()/intUnlock() here -- how atomic do you want to be? */
  taskLock();
  i++;
  taskUnlock();
}

/* Atomically increment a 32-bit word. */
void
nasd_atomic_inc32(nasd_int32 i)
{
  taskLock();
  i++;
  taskUnlock();
}
