/*
 * nasd_tests.c
 *
 * Internal kit for regression tests
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#include <nasd/nasd_options.h>

#if NASD_COMMON_TEST > 0

#include <nasd/nasd_types.h>
#include <nasd/nasd_mem.h>
#include <nasd/nasd_common.h>
#include <nasd/nasd_general.h>

nasd_status_t
nasd_atomic_test()
{
  nasd_timespec_t ts1, ts2;
  nasd_uint64 a, b, c;
  int failed;

  failed = 0;

  a = 1;
  b = 2;
  c = 3;

  NASD_ATOMIC_INC64(&a);
  if (a != 2) {
    nasd_printf("NASD ERROR: failed NASD_ATOMIC_INC64\n");
    nasd_printf("  got a=%" NASD_64u_FMT " expected 2\n", a);
    failed++;
  }

  NASD_ATOMIC_ADD64(&c, b);
  if (c != 5) {
    nasd_printf("NASD ERROR: failed NASD_ATOMIC_ADD64\n");
    nasd_printf("  got c=%" NASD_64u_FMT " expected 5\n", c);
    failed++;
  }

  NASD_ATOMIC_SUB64(&b, a);
  if (b != 0) {
    nasd_printf("NASD ERROR: failed NASD_ATOMIC_SUB64\n");
    nasd_printf("  got b=%" NASD_64u_FMT " expected 0\n", b);
    failed++;
  }

  NASD_ATOMIC_DEC64(&c);
  if (c != 4) {
    nasd_printf("NASD ERROR: failed NASD_ATOMIC_DEC64\n");
    nasd_printf("  got c=%" NASD_64u_FMT " expected 0\n", c);
    failed++;
  }

  ts1.ts_sec  = 12345;
  ts1.ts_nsec = 123456789;
  ts2.ts_sec  = 65432;
  ts2.ts_nsec = 543210000;

  NASD_ATOMIC_TIMESPEC_ADD(&ts1, &ts2);
  if ((ts1.ts_sec != 77777) || (ts1.ts_nsec != 666666789)
    || (ts2.ts_sec != 65432) || (ts2.ts_nsec != 543210000))
  {
    nasd_printf("NASD ERROR: failed NASD_ATOMIC_TIMESPEC_ADD\n");
    nasd_printf("  got ts1=%d:%09d ts2=%d:%09d\n",
      ts1.ts_sec, ts1.ts_nsec, ts2.ts_sec, ts2.ts_nsec);
    nasd_printf("  expected ts1=77777:666666789 ts2=65432:543210000\n");
  }

  ts1.ts_sec  = 5;
  ts1.ts_nsec = 999999999;
  ts2.ts_sec  = 1;
  ts2.ts_nsec = 2;

  NASD_ATOMIC_TIMESPEC_ADD(&ts1, &ts2);
  if ((ts1.ts_sec != 7) || (ts1.ts_nsec != 1)
    || (ts2.ts_sec != 1) || (ts2.ts_nsec != 2))
  {
    nasd_printf("NASD ERROR: failed NASD_ATOMIC_TIMESPEC_ADD\n");
    nasd_printf("  got ts1=%d:%09d ts2=%d:%09d\n",
      ts1.ts_sec, ts1.ts_nsec, ts2.ts_sec, ts2.ts_nsec);
    nasd_printf("  expected ts1=7:000000001 ts2=1:000000002\n");
    failed++;
  }

  ts2.ts_sec  = 5;
  ts2.ts_nsec = 6;

  NASD_ATOMIC_TIMESPEC_ADD(&ts1, &ts2);
  if ((ts1.ts_sec != 12) || (ts1.ts_nsec != 7)
    || (ts2.ts_sec != 5) || (ts2.ts_nsec != 6))
  {
    nasd_printf("NASD ERROR: failed NASD_ATOMIC_TIMESPEC_ADD\n");
    nasd_printf("  got ts1=%d:%09d ts2=%d:%09d\n",
      ts1.ts_sec, ts1.ts_nsec, ts2.ts_sec, ts2.ts_nsec);
    nasd_printf("  expected ts1=12:000000007 ts2=5:000000006\n");
    failed++;
  }

  if (failed)
    return(NASD_FAIL);

  nasd_printf("NASD: Passed simple tests of atomic ops\n");

  return(NASD_SUCCESS);
}

#endif /* NASD_COMMON_TEST > 0 */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
