/*
 * nasd_dux_srv.c
 *
 * nasd_srv() syscall front-end
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#include <nasd/nasd_options.h>
#include <nasd/nasd_sys.h>

/* 
 * We stick this here instead of in nasd_dux_basic.c so that
 * when we link the standalone client library, we don't suck in
 * nasd_dux_basic.o. Yeah, I know. "Sorry."
 */
nasd_uint64 nasd_ctimer_ticks;

/*
 * nasd_srv
 * (user-level only)
 *
 * nasd_srv() system call: takes two arguments
 * int cmd, and void *arg
 */
int
nasd_srv(cmd, arg)
  int    cmd;
  void  *arg;
{
  int rc;

  rc = syscall(247, cmd, arg);
  return(rc);
}

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
