/*
 * nasd_pdrive_client_modinit_sal.c
 *
 * Register rpc-specific modules for standalone library
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#include <nasd/nasd_options.h>
#include <nasd/nasd_pdrive_client.h>
#include <nasd/nasd_pdrive_client_kpdev.h>

nasd_drive_default_bindings_t nasd_drive_sal_bindings;
int nasd_drive_sal_bindings_handles[] = {
  NASD_BIND_KPDEV_DEFAULT
};

void
nasd_cl_p_mods_load()
{
  nasd_drive_sal_bindings.bindings = nasd_drive_sal_bindings_handles;
  nasd_drive_sal_bindings.nbindings =
    sizeof(nasd_drive_sal_bindings_handles) / sizeof(int);
  nasd_drive_default_bindings = &nasd_drive_sal_bindings;

  nasd_cl_p_kpdev_register(1);
}

/*
 * We're single-threaded, so we just use the regular
 * libc stuff
 */
nasd_status_t
nasd_gethostbyname_r(
  char            *drive_name,
  struct hostent  *he)
{
  struct hostent *hep;

  hep = gethostbyname(drive_name);
  if (hep == NULL)
    return(NASD_FAIL);

  *he = *hep;

  return(NASD_SUCCESS);
}

static nasd_timespec_t nasd_sal_last_time = {0,0};
static nasd_timespec_t nasd_sal_uniq_time = {0,0};

/*
 * "Good enough" for SAL
 */
void
nasd_gettime(
  nasd_timespec_t  *tm)
{
  struct timeval tv;

  gettimeofday(&tv, NULL);
  tm->ts_sec = tv.tv_sec;
  tm->ts_nsec = tv.tv_usec*1000;
  if ((tm->ts_sec == nasd_sal_last_time.ts_sec)
    && (tm->ts_nsec == nasd_sal_last_time.ts_nsec))
  {
    nasd_sal_uniq_time.ts_nsec++;
    if (nasd_sal_uniq_time.ts_nsec >= NASD_NSEC_PER_SEC) {
      nasd_sal_uniq_time.ts_nsec -= NASD_NSEC_PER_SEC;
      nasd_sal_uniq_time.ts_sec++;
    }
    *tm = nasd_sal_uniq_time;
  }
  else {
    nasd_sal_last_time = *tm;
    nasd_sal_uniq_time = nasd_sal_last_time;
  }
}

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
