#include <sys/stat.h>
#include <sys/types.h>
#include <sys/time.h>
#include <time.h>

#define DECLARE_TIME \
 double init_tstamp, final_tstamp, tt; \
 struct timeval tp; \
 int iter; \
 double avg;

#define INIT_TIME \
 iter = 0;


#define BEGIN_TIME \
gettimeofday (&tp, (struct timezone *) NULL); \
init_tstamp = tp.tv_sec + 1E-6*tp.tv_usec; \
iter = 0;

#define END_TIME \
 gettimeofday ( &tp, (struct timezone *) NULL); \
 iter++; \
 final_tstamp = tp.tv_sec + 1E-6*tp.tv_usec; \
 tt =  (final_tstamp - init_tstamp);

#define REPORT_TIME(_op_) { \
 avg = accum_time/iter; \
 (cheops_Msg "OPERATION: %s\n", _op_); \
 (cheops_Msg "  %lf seconds for %d operations\n", accum_time, iter); \
 (cheops_Msg "  %lf seconds average\n", avg); \
}

#define REPORT_BANDWIDTH(_mb_) \
 (cheops_Msg "Bandwidth %lf MB/sec\n", _mb_/accum_time);


            
