
#include <_sio_internal.h>

sio_return_t
sio_sg_read(int extfd, const sio_file_io_list_t *fl, sio_count_t fllen,
	const sio_mem_io_list_t *ml, sio_count_t mllen,
	sio_transfer_len_t *transferlenp)
{
	struct _sio_fdesc *intfd;
	struct _sio_iodesc *iodesc;
	sio_return_t rv;

	_sio_init();
	*transferlenp = 0;

	/* internalize file desc. structure (refcnt++) */
	intfd = _sio_exttable_internalize(_sio_exttable_fdescs, extfd);
	if (intfd == NULL)
		return (SIO_ERR_INVALID_DESCRIPTOR);

	/* create an I/O description for the I/O (refcnt = 1) */
	rv = _sio_iodesc_create(intfd, _SIO_IOD_READ, fl, fllen, ml, mllen,
	    &iodesc);
	if (rv != SIO_SUCCESS)
		goto bad1;

	/* do the I/O (refcnt unmodified) */
	/*_sio_timer_start(_SIO_TIMER_DOIO);*/
	_sio_iodesc_doio(iodesc);
	/*_sio_timer_stop(_SIO_TIMER_DOIO);*/

	/* collect the results and destroy the iodesc */
	/*_sio_timer_start(_SIO_TIMER_COLLECT_STATUS);*/
	_sio_iodesc_collect_status(iodesc, transferlenp, &rv);
	/*_sio_timer_stop(_SIO_TIMER_COLLECT_STATUS);*/

	_sio_rcobj_unref(intfd);		/* refcnt-- */
	return(rv);

bad2:
	_sio_iodesc_destroy(iodesc);		/* kill desc (refcnt = 1) */
bad1:
	_sio_rcobj_unref(intfd);		/* refcnt-- */
	return (rv);
}

sio_return_t
sio_sg_write(int extfd, const sio_file_io_list_t *fl, sio_count_t fllen,
	const sio_mem_io_list_t *ml, sio_count_t mllen,
	sio_transfer_len_t *transferlenp)
{
	struct _sio_fdesc *intfd;
	struct _sio_iodesc *iodesc;
	sio_return_t rv;

	_sio_init();
	*transferlenp = 0;

	/* internalize file desc. structure (refcnt++) */
	intfd = _sio_exttable_internalize(_sio_exttable_fdescs, extfd);
	if (intfd == NULL)
		return (SIO_ERR_INVALID_DESCRIPTOR);

	/* create an I/O description for the I/O (refcnt = 1) */
	rv = _sio_iodesc_create(intfd, _SIO_IOD_WRITE, fl, fllen, ml, mllen,
	    &iodesc);
	if (rv != SIO_SUCCESS)
		goto bad1;

	/* do the I/O (refcnt unmodified) */
	_sio_iodesc_doio(iodesc);

	/* collect the results and destroy the iodesc */
	_sio_iodesc_collect_status(iodesc, transferlenp, &rv);

	_sio_rcobj_unref(intfd);		/* refcnt-- */
	return(rv);

bad2:
	_sio_iodesc_destroy(iodesc);		/* kill desc (refcnt = 1) */
bad1:
	_sio_rcobj_unref(intfd);		/* refcnt-- */
	return (rv);
}
