/*
 * _sio_init.c
 *
 * SIO Library Internal Initialization Code
 *
 * Authors: Khalil Amiri, CMU SCS/ECE, July 18 1997
 *          Sean Levy, CMU SCS, July 1999
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */

#include "_sio_internal.h"

#ifndef _SIO_MNT_NASDPATH
#define _SIO_MNT_NASDPATH 1
#endif /* _SIO_MNT_NASDPATH */

static NASD_DECLARE_ONCE(_sio_init_once_block);
static int _sio_initted;

struct _sio_mntpoint_list _sio_mntpoint_list;

extern void sio_stdio_init();

void
_sio_init_once()
{
	struct _sio_mntpoint *mnt;
  int rc;

	_sio_exttable_fdescs =
	    _sio_exttable_create(_SIO_EXTTABLE_FILEDESC_UNIQ, SIO_MAX_OPEN);
	_sio_exttable_asynchandles =
	    _sio_exttable_create(_SIO_EXTTABLE_ASYNCHANDLE_UNIQ,
	    SIO_MAX_ASYNC_OUTSTANDING);

	rc = nasd_mutex_init(&_sio_async_io_count_mutex);
  if (rc) {
    NASD_PANIC();
  }
	_sio_async_io_count = 0;

	TAILQ_INIT(&_sio_mntpoint_list);

#if _SIO_MNT_NASDPATH > 0
	if ((mnt = _sio_mnt_nasdpath_init("sio-cheops-fs",
	    "/tmp/sio-fs-storage")) != NULL) {
		TAILQ_INSERT_TAIL(&_sio_mntpoint_list, mnt, mnt_link);
	}
#else
	if ((mnt = _sio_mnt_unixpath_init("sio-local-fs",
	    "/glenpinky/sio-fs-storage")) != NULL) {
		TAILQ_INSERT_TAIL(&_sio_mntpoint_list, mnt, mnt_link);
	}

#endif /* _SIO_MNT_NASDPATH */

	sio_stdio_init();
	_sio_initted = 1;
}

void
_sio_init()
{
  int rc;

  rc = nasd_cheops_client_init();
  if (rc) {
    NASD_PANIC();
  }
	nasd_once(&_sio_init_once_block, &_sio_init_once);
	if (!_sio_initted) {
    NASD_PANIC();
  }
}

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
