/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import java.util.List;
import jde.debugger.Etc;
import jde.debugger.JDEException;
import jde.debugger.ObjectStore;
import jde.debugger.command.DebugProcessCommand;

public class TraceThreads
extends DebugProcessCommand {
    public void doCommand() throws JDEException {
        if (this.args.size() < 2) {
            throw new JDEException("Insufficient arguments");
        }
        String type = this.args.remove(0).toString().toLowerCase();
        if (!type.equals("start") && !type.equals("death")) {
            throw new JDEException("Invalid type");
        }
        List classFilters = Etc.getClassFiltersFromArgs(this.args);
        List classExFilters = Etc.getClassExFiltersFromArgs(this.args);
        EventRequestManager em = this.proc.getVM().eventRequestManager();
        Long requestID = null;
        ObjectStore store = this.proc.getStore();
        if (type.equals("start")) {
            ThreadStartRequest ter = em.createThreadStartRequest();
            ter.setSuspendPolicy(Etc.getSuspendPolicyFromArgs(this.args));
            if (this.args.size() > 0) {
                Long threadID = Etc.safeGetLong(this.args.remove(0), "thread ID");
                ObjectReference tRef = store.get(threadID);
                if (tRef == null) {
                    throw new JDEException("No such thread exists");
                }
                if (!(tRef instanceof ThreadReference)) {
                    throw new JDEException("No such thread exists (anymore?)");
                }
                ter.addThreadFilter((ThreadReference)tRef);
            }
            requestID = this.addIdentifiableRequest(ter);
        } else if (type.equals("death")) {
            ThreadDeathRequest ter = em.createThreadDeathRequest();
            ter.setSuspendPolicy(Etc.getSuspendPolicyFromArgs(this.args));
            if (this.args.size() > 0) {
                Long threadID = Etc.safeGetLong(this.args.remove(0), "thread ID");
                ObjectReference tRef = store.get(threadID);
                if (tRef == null) {
                    throw new JDEException("No such thread exists");
                }
                if (!(tRef instanceof ThreadReference)) {
                    throw new JDEException("No such thread exists (anymore?)");
                }
                ter.addThreadFilter((ThreadReference)tRef);
            }
            requestID = this.addIdentifiableRequest(ter);
        }
        this.jde.signalCommandResult(this.procID, this.cmdID, requestID);
    }

    public Object clone() {
        return new TraceThreads();
    }
}

