/* Copyright 1991 by John Atwood deVries II. */
/* $Id: s_shuttime.c,v 1.13 2001/10/27 01:15:09 jwise Exp $ */
/* For copying and distribution information, see the file COPYING. */

/* primitive to print the version */

#include <stdio.h>
#include <string.h>
#include <time.h>
#include "externs.h"

void	s_shuttime (int, int);

void
s_shuttime(int n, int argc)
{
	long TheTime, TimeLeft;
	char line[LINE_SIZE];

        if (argc == 2)
		if (TimeToDie < 0.0)
			sendstatus(n, "Shutdown", "No shutdown time scheduled.");
		else {
			TheTime = time(NULL);
			TimeLeft = TimeToDie - TheTime;
			if (TimeLeft >= 3600.0) 
				snprintf(line, LINE_SIZE, "%d hour(s), %d minute(s) left until scheduled shutdown.",
						(int) (TimeLeft / 3600.0), (int) (((int) TimeLeft % 3600) / 60.0));
			else if (TimeLeft > 60.0)
				snprintf(line, LINE_SIZE, "%d minute(s) left until scheduled shutdown.", (int) (TimeLeft / 60.0));
			else
				snprintf(line, LINE_SIZE, "%d second(s) left until scheduled shutdown!", (int) TimeLeft);
			sendstatus(n, "Shutdown", line);
		}
        else {
                error("shuttime: wrong number of arguments");
        }
}
