/* Copyright 1991 by John Atwood deVries II. */
/* $Id: s_beep.c,v 1.12 2001/10/30 05:09:03 jwise Exp $ */
/* For copying and distribution information, see the file COPYING. */

/* primitive to send a beep */

#include <stdio.h>
#include <string.h>
#include "externs.h"

void	s_beep (int, int);

/* basically just a rewriting of s_person */
void
s_beep(int n, int argc)
{
	int	dest;
	char	*cp;
	char	line[LINE_SIZE];

	if (argc == 2) {
		/* constraints:
			destination nickname is not null
			destination nickname exists */

		cp = getword(fields[1]);
		if (cp == NULL) {
			error("Null string in beep");
			return;
			}
		if (strlen(cp) == 0) {
			error("Null string in beep");
		} else {
                	if( (dest = find_user(cp)) < 0) {
                       		/* error - no such nick */
				snprintf(line, LINE_SIZE, "%s not signed on.", cp);
                        	senderror(n, line);
                	} else {
				/* send a message to that nick */
				sendbeep(n, dest);
                	}
		}
        } else {
                error("beep: wrong number of arguments");
        }
}

