/* Copyright 1991 by John Atwood deVries II. */
/* $Id: s_admin.c,v 1.21 2001/10/30 05:09:03 jwise Exp $ */
/* For copying and distribution information, see the file COPYING. */

/* primitives to deal with admin commands */

#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "externs.h"

void	s_drop (int, int);
void	s_shutdown (int, int);
void	s_restart (int, int);
void	s_wall (int, int);
int	check_auth (int);

void
s_drop(int n, int argc)
{
	int	TheVictim;
	char	line[LINE_SIZE];

	if (argc == 2) {
		/* fields[1] can be a string, not just a single nick */
		TheVictim = find_user(getword(fields[1]));
		if (TheVictim < 0) {
			senderror(n, "User not found.");
		} else if (check_auth(n))
			disconnectuser(TheVictim);
		else if (valuser(u_tab[TheVictim].nickname, getword(get_tail(fields[1]))) == 0) {
				snprintf(line, LINE_SIZE, "You have been disconnected by %s", u_tab[n].nickname);
				sendstatus(TheVictim, "Drop", line);
				snprintf (line, LINE_SIZE, "[DROP] %s (%d) dropped %s (%d)", u_tab[n].nickname, n, getword(fields[1]), TheVictim);
				MDB(line);
				S_kill[TheVictim]++;
		} else
			senderror(n, "Authentication failure.");
	} else
		error("drop: wrong number of arguments");
}

void
s_shutdown(int n, int argc)
{
	int user;
	char line[LINE_SIZE];

	/* before we even look at what they sent us, are the allowed? */
	if (!check_auth(n)) {
		senderror(n,"You are not authorized to do this.");
		return;
	}
	if (argc == 2) {
		/* fields[1] is when and comments, separated by a blank */
		/* BUG	we are presuming when is always now.
			...but then, I don't know how to schedule
			anything anyhow.
			we are presuming that no warning is given */
		snprintf(line, LINE_SIZE, "Server going down in %ld minute(s)!", atol(fields[1]));
        	for (user=0; user < MAX_REAL_USERS; user++)
			if (u_tab[user].login == 1)
                        	sendimport(user,"Shutdown", line);
		TimeToDie = time(NULL) + 60.0 * atol(fields[1]);
		ShutdownNotify = 0;
		if (atol(fields[1]) < 300)
			ShutdownNotify++;
	} else {
		error("shutdown: wrong number of arguments");
	}
}

/*ARGSUSED*/
void
s_restart(int n, int argc)
{
	int user;
	char *args[3];
	char *env[2];

	/* before we even look at what they sent us, are the allowed? */
	if (!check_auth(n)) {
		senderror(n,"You are not authorized to do this.");
		return;
	}
       	for (user=0; user < MAX_REAL_USERS; user++)
		if (u_tab[user].login == 1)
                       	sendimport(user,"Restart", 
			 "Server restarting...please be patient.");
	MDB("[RESTART] Server restarting");
	icbdump(0);
	close_logs();
	args[0] = "icbd";
	args[1] = "-R";
	args[2] = NULL;
	env[0] = "RESTART=Y";
	env[1] = NULL;
	fcntl(6, F_GETFD, 0);
	if (fork()) exit(0);

	if (execve("./icbd", args, env) < 0) {
		error("RESTART failed: %s", strerror(errno));
               	sendimport(n, "Restart", "Restart not done.");
		MDB("[RESTART] Restart failed");
		return;
	}
}

void
s_wall(int n, int argc)
{
	int user;

	/* before we even look at what they sent us, are the allowed? */
	if (!check_auth(n)) {
		senderror(n,"You are not authorized to do this.");
		return;
	}
	if (argc == 2) {
		/* send it only to the real users */
        	for (user=0; user < MAX_REAL_USERS; user++) {
			if (u_tab[user].login == 1) {
                        	sendimport(user,"WALL", fields[1]);
                	}
        	}
	} else {
		error("wall: wrong number of arguments");
	}
}

int
check_auth(int n)
{
	int auth;

	auth = 0;
	info("Checking authorization of %s (%s)", u_tab[n].nickname, u_tab[n].password);
	if (strcasecmp(u_tab[n].nickname, "ADMIN") == 0)
		auth++;
	if (strcasecmp(u_tab[n].password, TheKey) == 0)
		auth++;
	return (auth == 2);
}
