/* Copyright (c) 1988 Carrick Sean Casey. All rights reserved. */
/* $Id$ */

/* start listening on our official port */
/* returns socket for new connects */

#include <sys/file.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "externs.h"
 
int	makenewport (char *, int);

int
makenewport(char *host_name, int port_number)
{
	struct addrinfo hints, *res, *a;
	int optval = 1;
	int s;
	int flags;
	int err;
	char p[10];

	memset(&hints, 0, sizeof(hints));
	hints.ai_family = PF_UNSPEC;
	hints.ai_flags = AI_PASSIVE;
	hints.ai_socktype = SOCK_STREAM;
	snprintf(p, 9, "%d", port_number);

	if ((err = getaddrinfo(host_name, p, &hints, &res)) != 0) {
		perror(gai_strerror(err));
		return(-1);
	}

	a = res;

	FD_ZERO(&fdset);

	while (a) {
		/* create a socket */
		if ((s = socket(a->ai_family, a->ai_socktype, a->ai_protocol )) < 0) {
			perror("makenewport: socket");
			return(-1);
		}

		if(setsockopt(s, SOL_SOCKET, SO_REUSEADDR, (void *)&optval, sizeof(optval)) < 0) {
			perror("makenewport: setsockopt");
		}

		/* bind it to the inet address */
		if (bind(s, a->ai_addr, a->ai_addrlen) < 0) {
			perror("makenewport: bind");
			return(-1);
		}

		/* start listening for connections */
		listen(s, 5);

		/* Don't close on exec */
		flags = fcntl(s, F_GETFD, 0);
		flags = flags & ~ FD_CLOEXEC;
		if (fcntl(s, F_SETFD, flags) < 0) {
			perror("CLOEXEC");
			exit (-1);
		}

		optval = 24576;
		if (setsockopt(s, SOL_SOCKET, SO_SNDBUF, (void *)&optval, sizeof(optval)) < 0)
			perror("SO_SNDBUF");

		FD_SET(s, &fdset);
		FD_SET(s, &serversocks);

		if (s > highestfd)
			highestfd = s;

		a = a->ai_next;
	}

	freeaddrinfo(res);

	/* allow us to handle problems gracefully */
	signal(SIGPIPE, SIG_IGN);

	return(0);
}
