#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <pwd.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include "icb.h"
#include "config.h"

struct server	*getserver (void);
struct server	*getserverbyname (char *name);
void	listservers (void);
static FILE	*openserverfile (void);
static int	readserverent (FILE *fd, struct server *buffer);

/*
 * serverlist.c - management routines for the server list
 */

static struct server serverbuf;

static FILE *serverfile = NULL;

static FILE *
openserverfile (void)
{
	struct stat statbuf;
	char *home;
	char pwd[MAXPATHLEN+1];
	FILE *ret;

	getcwd(pwd, MAXPATHLEN+1);
	if ((home = getenv("HOME")) == NULL) {
		struct passwd *pw;
		if ((pw = getpwuid(getuid())) == NULL)
			home = ".";
		home = pw->pw_dir;
	}
	chdir(home);
	if (!stat(PERSONALSL,&statbuf))
	{
		char *command = malloc(strlen("/bin/cat  \n") + strlen(PERSONALSL) + strlen(SERVERLIST) + 1);
		sprintf(command, "/bin/cat %s %s\n", PERSONALSL, SERVERLIST);
		ret= popen(command,"r");
		free(command);
	}
	else
		ret= fopen(SERVERLIST,"r");
	chdir(pwd);
	return ret;
}


struct server *
getserver (void)
{
	static int def = 0;

	if (serverfile == NULL)
	{
		if (!(serverfile=openserverfile()))
		{
			if (!def)
			{
				def=1;
				strcpy(serverbuf.host, DEFAULTHOST);
				serverbuf.port = DEFAULTPORT;
				return &serverbuf;
			}
			else
				return NULL;
		}
	}


	if (!readserverent(serverfile, &serverbuf))
	{	
		fclose(serverfile);
		serverfile = NULL;
		return NULL;
	}

	return &serverbuf;
}

struct server *
getserverbyname (char *name)
{
	if (!serverfile) {
		if (!(serverfile=openserverfile()))
			return NULL;
	} else {
		rewind(serverfile);
	}

	while (readserverent(serverfile, &serverbuf))
	{
		if (!strcmp(name, serverbuf.name))
			return &serverbuf;
	}
	fclose(serverfile);
	serverfile = NULL;
	return NULL;
}

void
listservers (void)
{
	if (!serverfile) {
		if (!(serverfile=openserverfile()))
			return;
	} else {
		rewind(serverfile);
	}

	printf("%-16s%-32s%5s\n", "SERVER", "HOST", "PORT");
	while (readserverent(serverfile, &serverbuf))
	{
		printf("%-16s%-32s%5d\n", serverbuf.name, serverbuf.host,
serverbuf.port);
	}
}

static int
readserverent (FILE *fd, struct server *buffer)
{
	char line[256];
	int index;

	for (;;)
	{
	if (!fgets(line,256,fd))
	{
		return 0;
	}

	index = 0;

	while (line[index] && isspace(line[index]))
		++index;

	if (!line[index] || line[index] == '#')
	{
		continue;
	}
		
	if ((sscanf(line, "\"%[^\"]\" %s %d", buffer->name, buffer->host,
		&(buffer->port))!=3) &&
		(sscanf(line, "%s %s %d", buffer->name, buffer->host,&(buffer->port))!=3))
	{
		buffer->port = DEFAULTPORT;
		if ((sscanf(line, "\"%[^\"]\" %s", buffer->name, buffer->host)!=2) &&
		    (sscanf(line, "%s %s", buffer->name, buffer->host)!=2))
		{
			if (sscanf(line, "%s", buffer->host) == 1)
			{
			strcpy(buffer->name, buffer->host);
		}
		else
		{
			fprintf(stderr,"Bad server entry: %sSkipping...\n",line);
			continue;
		}
	}
	}

	return 1;
	}
}
