/* Copyright (c) 1989 by Carrick Sean Casey. All rights reserved. */
/* For copying and distribution information, see the file "copyright.h." */

/* external definitions for "icb" global variables */

/* defined in port.c */
extern char *hostname; 	/* default hostname for connects */

/* defined in split.c */
extern char *fields[MAX_FIELDS];	/* split fields */

/* global icb variables settable with oset */
extern GLOBS gv;
extern TTYINFO ttyinfo;
	
/* defined in globals.c */
extern char *what_version;		/* ICB client version */
#define icb_version (what_version+5)	/* . . . without leading what(1) key */
extern char *pp;		/* packet pointer */
extern char *pbuf;		/* packet buffer pointer */
extern char *mynick;		/* nickname of user */
extern char *myloginid;		/* login id */
extern char *mypass;		/* password of user */
extern char *mygroup;		/* requested group */
extern char *myserver;		/* server name */
extern char *myhost;		/* server host */
extern int myport;		/* server port */
extern char *mbuf;		/* message buffer */
extern char *mbuf2;		/* message buffer */
extern int connected;		/* whether we are validated or not */
extern char continued;		/* did we bg then fg this job? */
extern int whoflg;		/* just do a who at startup */
extern time_t curtime;		/* current time */
extern int linenumber;
extern int echomode;		/* whether tty echo is on or off */
extern int match_exact;		/* used by histmatch() */

extern int m_whoheader;		/* who header output */
extern int m_groupheader;	/* group header output */

/* for getswitch() */
extern int switcherr, switchind;
extern char *switcharg;

/* function prototypes */
int	addusage (char *name, char type, char *args, char *usage);
char	*ampm (time_t secs, int style);
void	askquit (int n);
void	beep (char *pkt);
void	bufferadd (char *text);
void	c_didpoll (void);
int	c_hclear (TARGLIST);
int	c_hdel (TARGLIST);
int	c_help (TARGLIST);
int	c_hush (TARGLIST);
int	c_log (TARGLIST);
void	c_lostcon (void);
void	c_packet (char *pkt);
int	c_quit (TARGLIST);
int	c_rand (TARGLIST);
int	c_replay (TARGLIST);
int	c_shell (TARGLIST);
int	c_time (TARGLIST);
int	c_usage (TARGLIST);
void	c_userchar (void);
int	c_version (TARGLIST);
char	*catargs (char **argv);
void	clearargs (int argc, char **argv);
int	clientserve (void);
void	closesessionlog (void);
void	cmdoutmsg (char *pkt);
int	connecttoport (char *host_name, int port_number);
void	copenmsg (char *pkt);
void	cpersonalmsg (char *pkt);
void	csendopen (char *txt);
void	deleteusage (char *name);
void	dispatch (char *pkt);
void	echo (void);
void	errormsg (char *pkt);
void	exitmsg (void);
char	*findspace (char *s);
char	*getline (char *prompt, int expand);
char	*getloginid (void);
char	*getswitch (int argc, char **argv, char **switchv);
void	getterm (void);
void	gettime (void);
void	getwinsize (void);
char	*getword (char *s);
void	handletab (int count, char c);
void	histclear (void);
int	histcount (void);
void	histdel (char *name);
char	*histget (void);
char	*histmatch (char *prefix);
void	histput (char *nick);
void	icbexit (int);
void	icbterm (void);
void	importantmsg (char *pkt);
int	ishushed (char *nick);
void	linebuffer (FILE *fp);
void	listservers (void);
void	listusage (char *name);
int	logging (void);
void	loginokmsg (char *pkt);
void	mbreakprint (int per, char *from, char *s);
void	noecho (void);
int	oset (TARGLIST);
int	ounset (TARGLIST);
void	parse (char *s);
void	pauseprompt (char *prompt, int Erase, char c, int unget, char *except);
void	protomsg (char *pkt);
void	pushback (char c);
void	putl (char *s, int flags);
void	quoteify (char *a, char *b);
void	readlineinit (void);
void	regnick (char *password);
void	restoreterm (void);
void	restrict (void);
int	s_admin (TARGLIST);
int	s_beep (TARGLIST);
int	s_bump (TARGLIST);
int	s_chpw (TARGLIST);
int	s_group (TARGLIST);
int	s_motd (TARGLIST);
int	s_open (TARGLIST);
int	s_personal (TARGLIST);
int	s_register (TARGLIST);
int	s_send (TARGLIST);
int	s_user (TARGLIST);
int	s_version (TARGLIST);
int	s_who (TARGLIST);
void	saysomething (void);
void	send_default (char *text, int echoflag);
int	sendcmd (char *cmd, char *args);
void	sendit (char *pkt);
void	sendlogin (char *id, char *nick, char *group, char *command, char *passwd);
void	sendpersonal (char *nick, char *text, int echoflag);
void	sendpong (void);
int	split (char *s);
void	statusmsg (char *pkt);
STRLIST	*strgetnode (char *str, STRLIST *head, int caseindep);
void	strlinkalpha (STRLIST *s, STRLIST **head, STRLIST **tail, int caseindep);
void	strlinkbefore (STRLIST *s, STRLIST *i, STRLIST **head, STRLIST **tail);
void	strlinkhead (STRLIST *s, STRLIST **head, STRLIST **tail);
void	strlinktail (STRLIST *s, STRLIST **head, STRLIST **tail);
STRLIST	*strmakenode (int size);
void	strunlink (STRLIST *s, STRLIST **head, STRLIST **tail);
void	suspend (int n);
void	tclinit (void);
void	tclreadicbrc (void);
char	*tildexpand (char *s);
void	trapsignals (void);
int	wordcmp (char *s1, char *s2);
struct server	*getserver (void);
struct server	*getserverbyname (char *name);
