<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;"> <!ENTITY lf "&#10;">] >

<!-- $NetBSD: port-maintainers.xsl,v 1.6 2025/08/09 19:07:14 andvar Exp $ -->

<!-- Copyright (c) 2007
	The NetBSD Foundation, Inc.  ALL RIGHTS RESERVED. -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:vendor="http://exslt.org/common"
		exclude-result-prefixes="vendor"
                version="1.0">
  
  <xsl:import href="netbsd-webpage-en.xsl"/>

  <xsl:include href="listmaintports.xsl"/>

  <xsl:output indent="yes"/>
  <xsl:strip-space elements="people"/>

  <xsl:template match="ports">
      <xsl:variable name="oportnames">
	<xsl:call-template name="sortuniqports">
	  <xsl:with-param name="duplicports" select="port"/>
	</xsl:call-template>
      </xsl:variable>
    <xsl:call-template name="porttable">
      <xsl:with-param name="duplicports" select="port"/>
      <xsl:with-param name="portnames" select="vendor:node-set($oportnames)"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="porttable">
    <xsl:param name="duplicports"/>
    <xsl:param name="portnames"/>
    
    <xsl:for-each  select="$portnames/port">
      <xsl:variable name="color">
	<xsl:choose>
	  <xsl:when test="position() mod 2 = 0">#ffffff</xsl:when>
	  <xsl:otherwise>#f1f1f1</xsl:otherwise>
	</xsl:choose>
      </xsl:variable>

      <xsl:variable name="portname" select="@name"/>	
      <xsl:for-each select="$duplicports[@name=current()/@name]/maintainer">
	<tr style="background-color: $color ;">
	  <xsl:attribute name="style">
	    background-color: <xsl:value-of select="$color"/>;
	  </xsl:attribute>
	  <xsl:text>&lf;  </xsl:text><td>
	    <xsl:choose>
	      <xsl:when test="position() = 1">
		<ulink>
		  <xsl:attribute name="url">
		    <xsl:value-of select="concat('../ports/',$portname,'/')"/>
		  </xsl:attribute>
		  <xsl:value-of select="$portname"/>
		</ulink>
	      </xsl:when>
	      <xsl:otherwise>&nbsp;</xsl:otherwise>
	    </xsl:choose>
	  </td>
	<xsl:variable name="maint" select="$duplicports[@name=current()/@name]/maintainer"/>
	<xsl:text>&lf;  </xsl:text><td><xsl:choose><xsl:when test="url">
	  <ulink>
	    <xsl:attribute name="url">
	      <xsl:value-of select="url"/>
	    </xsl:attribute>
	    <xsl:value-of select="name"/>
	  </ulink></xsl:when>
	  <xsl:otherwise><xsl:value-of select="name"/></xsl:otherwise>
	</xsl:choose></td>
	<xsl:text>&lf;  </xsl:text><td><xsl:copy-of select="email"/></td>
	</tr><xsl:text>&lf;</xsl:text>
      </xsl:for-each>
    </xsl:for-each>
  </xsl:template>
  
  <!-- process the <porttable/> element, replacing it by a table of ports
       and maintainers. -->
  <xsl:template match="porttable" mode="copy" priority="0">
    <!-- portlist will contain a list of port with their maintainers
         in the following format:
	 <ports>
	 <port name="eniac">
	 <maintainer><name>John Foo</name><email>foo@</email></maintainer>
	 </port>
	 (...)
	 </ports>
    -->
    <xsl:variable name="portlist">
      <xsl:call-template name="devdb2ports"/>
    </xsl:variable>
    
    <!-- there is a template matching <ports> which take care of
         transforming this to the desired result. -->
    <xsl:apply-templates  select="vendor:node-set($portlist)/ports"/> 
  </xsl:template>


  <xsl:template match="@*|node()" mode="copy">
	<xsl:copy>
	  <xsl:apply-templates select="@*|node()" mode="copy"/>
	</xsl:copy>
  </xsl:template>

  <xsl:template match="/">
    <!-- we copy the whole document, only replacing <porttable/> by
         docbook.html table rows.  -->
    <xsl:variable name="docbooktext">
      <xsl:apply-templates  mode="copy"/>
    </xsl:variable>
    <!-- then we apply sandard docbook templates to the result -->
    <xsl:apply-templates mode="docbook" select="vendor:node-set($docbooktext)"/>
  </xsl:template>

  <xsl:template match="/" mode="docbook">
    <xsl:apply-templates/>
  </xsl:template>
</xsl:stylesheet>
