<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet
  PUBLIC "-//NetBSD/DTD NetBSD XSLT 1.0 DTD//EN"
	 "http://www.NetBSD.org/XML/htdocs/share/xml/xslt10-netbsd.dtd">

<!-- $NetBSD: citerefentry.xsl,v 1.6 2025/07/24 18:09:59 martin Exp $ -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:html="http://www.w3.org/1999/xhtml"
		exclude-result-prefixes="html"
		version="1.0">

  <!-- XSL template to generate man reference link -->

  <xsl:template match="citerefentry">
    <!--
      "release" attribute can be used on a webpage template to set all
      man references to a specific release version.

      "os" attribute can be used on citerefentry template to set a specific
      release version for the man reference and it will override the release 
      attribute above.
    -->
    <xsl:variable name="release" select="@os"/>
    <xsl:variable name="webpagerelease" select="ancestor::webpage/@release"/>
    <!-- arch attribute should be used to specify the architecture --> 
    <xsl:variable name="arch" select="@arch"/>
    <a>
      <xsl:attribute name="href">
        <xsl:text>//man.NetBSD.org/</xsl:text>
        <xsl:text>&os;-</xsl:text>
        <xsl:choose>
          <xsl:when test="boolean($release)">
            <xsl:value-of select="$release"/>
          </xsl:when>
          <xsl:when test="boolean($webpagerelease)">
            <xsl:value-of select="$webpagerelease"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>&release.latest;</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:text>/</xsl:text>
        <xsl:choose>
          <xsl:when test="boolean($arch)">
            <xsl:value-of select="$arch"/>
            <xsl:text>/</xsl:text> 
          </xsl:when>
        </xsl:choose>
        <xsl:value-of select="refentrytitle"/>
        <xsl:text>.</xsl:text>
        <xsl:value-of select="manvolnum"/>
      </xsl:attribute>
      <xsl:value-of select="refentrytitle"/>
      <xsl:text>(</xsl:text>
      <xsl:value-of select="manvolnum"/>
      <xsl:text>)</xsl:text>
    </a>
  </xsl:template>

  <!--
    With mode="plaintext" the template produces plain text without any markup.
    This can be used to get nicer output than the simple text concatenation of
    "xsl:value-of".
  -->
  <xsl:template match="citerefentry" mode="plaintext">
    <xsl:value-of select="refentrytitle"/>
    <xsl:text>(</xsl:text>
    <xsl:value-of select="manvolnum"/>
    <xsl:text>)</xsl:text>
  </xsl:template>

</xsl:stylesheet>

