<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:exsl="http://exslt.org/common"
                xmlns:xi="http://www.w3.org/2001/XInclude"
                version="1.0">

<!-- $NetBSD: autolayout.xsl,v 1.3 2006/07/30 19:04:43 rillig Exp $ -->

<xsl:import href="http://docbook.sourceforge.net/release/website/2.6.0/xsl/autolayout.xsl" />

<xsl:output method="xml" indent="no"
            doctype-public="-//Norman Walsh//DTD Website Autolayout V2.5.0//EN"
            doctype-system="http://docbook.sourceforge.net/release/website/2.5.0/schema/dtd/autolayout.dtd"
/>

<xsl:template match="toc">
  <xsl:if test="not(@page)">
    <xsl:message terminate="yes">
      <xsl:text>All toc entries must have a page attribute.</xsl:text>
    </xsl:message>
  </xsl:if>

  <!--
  <xsl:variable name="page" select="document(@page,.)"/>
  -->

  <toc>
    <xsl:call-template name="tocentry"/>
  </toc>
  <xsl:text>&#10;</xsl:text>
</xsl:template>

<xsl:template name="tocentry.page">
  <xsl:if test="not(@page)">
    <xsl:message terminate="yes">
      <xsl:text>All toc entries must have a page attribute.</xsl:text>
    </xsl:message>
  </xsl:if>

  <xsl:variable name="page-href" select="@page" />

  <xsl:variable name="id">
    <xsl:choose>
       <xsl:when test="@id">
          <xsl:value-of select="@id" />
       </xsl:when>
       <xsl:otherwise>
         <!-- <xsl:text>&amp;substid-</xsl:text> -->
         <xsl:value-of select="translate(substring-before($page-href, '.xml'), '/', '-')" />
         <!-- <xsl:text>;</xsl:text> -->
       </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="filename">
    <xsl:choose>
      <xsl:when test="@filename">
        <xsl:value-of select="@filename"/>
      </xsl:when>
      <xsl:when test="/layout/config[@param='default-filename']">
        <xsl:value-of select="(/layout/config[@param='default-filename'])[1]/@value"/>
      </xsl:when>
      <xsl:otherwise>index.html</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="dir">
    <xsl:apply-templates select="." mode="calculate-dir"/>
  </xsl:variable>

  <xsl:if test="$filename = ''">
    <xsl:message terminate="yes">
      <xsl:value-of select="@page"/>
      <xsl:text>: missing filename.</xsl:text>
    </xsl:message>
  </xsl:if>

<!--
  <xsl:message>
    <xsl:value-of select="@page"/>
    <xsl:text>: </xsl:text>
    <xsl:if test="$dir != ''">
      <xsl:value-of select="$dir"/>
    </xsl:if>
    <xsl:value-of select="$filename"/>
  </xsl:message>
-->

  <xsl:attribute name="page">
    <xsl:value-of select="@page"/>
  </xsl:attribute>
  <xsl:attribute name="id">
    <xsl:value-of select="$id"/>
  </xsl:attribute>
  <xsl:if test="$dir != ''">
    <xsl:attribute name="dir">
      <xsl:value-of select="$dir"/>
    </xsl:attribute>
  </xsl:if>
  <xsl:attribute name="filename">
    <xsl:value-of select="$filename"/>
  </xsl:attribute>
  <xsl:if test="@tocskip = '1'">
    <xsl:attribute name="tocskip">
      <xsl:value-of select="@tocskip"/>
    </xsl:attribute>
  </xsl:if>

  <xsl:text>&#10;</xsl:text>
  <xsl:choose>
    <xsl:when test="title">
      <xsl:apply-templates select="title" mode="copy"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:element name="xi:include">
         <xsl:attribute name="href">
           <!--
           <xsl:value-of select="concat('http://www.NetBSD.org/XML/htdocs/', $page-href)" />
           -->
           <xsl:value-of select="$page-href" />
         </xsl:attribute>
         <xsl:attribute name="xpointer">
           <xsl:value-of select="'xpointer(/*[1]/head/title)'" />
         </xsl:attribute>

         <xsl:element name="xi:fallback">
           <xsl:text>No Title</xsl:text>
         </xsl:element>
      </xsl:element>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:text>&#10;</xsl:text>

  <xsl:variable name="page-titleabbrev">
    <xsl:choose>
      <xsl:when test="element-available('xi:include')">
        <xi:include href="{$page-href}" xpointer="xpointer(/*[1]/head/titleabbrev/*)">
          <xi:fallback />
        </xi:include>
      </xsl:when>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="page-summary">
    <xsl:choose>
      <xsl:when test="element-available('xi:include')">
        <xi:include href="{$page-href}" xpointer="xpointer(/*[1]/head/titleabbrev/*)">
          <xi:fallback />
        </xi:include>
      </xsl:when>
    </xsl:choose>
  </xsl:variable>

  <xsl:if test="titleabbrev or $page-titleabbrev != ''">
    <xsl:choose>
      <xsl:when test="titleabbrev">
        <xsl:apply-templates select="titleabbrev" mode="copy"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test="element-available('xi:include')">
            <titleabbrev>
              <xi:include href="{$page-href}" xpointer="xpointer(/*[1]/head/titleabbrev/*)">
                <xi:fallback />
              </xi:include>
            </titleabbrev>
          </xsl:when>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:text>&#10;</xsl:text>
  </xsl:if>

  <xsl:if test="summary or $page-summary != ''">
    <xsl:choose>
      <xsl:when test="summary">
        <xsl:apply-templates select="summary" mode="copy"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test="element-available('xi:include')">
            <summary>
              <xi:include href="{$page-href}" xpointer="xpointer(/*[1]/head/summary/*)" />
            </summary>
          </xsl:when>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:text>&#10;</xsl:text>
  </xsl:if>

  <xsl:apply-templates select="tocentry"/>
</xsl:template>

<xsl:template match="*" mode="calculate-dir">
  <xsl:choose>
    <xsl:when test="starts-with(@dir, '/')">
      <!-- if the directory on this begins with a "/", we're done... -->
      <xsl:value-of select="substring-after(@dir, '/')"/>
      <xsl:text>/</xsl:text>
    </xsl:when>

    <xsl:when test="parent::*">
      <!-- if there's a parent, try it -->
      <xsl:apply-templates select="parent::*" mode="calculate-dir"/>
      <xsl:if test="@dir">
        <xsl:value-of select="@dir"/>
        <xsl:text>/</xsl:text>
      </xsl:if>
    </xsl:when>

    <xsl:otherwise>
      <xsl:if test="@dir">
        <xsl:value-of select="@dir"/>
        <xsl:text>/</xsl:text>
      </xsl:if>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

</xsl:stylesheet>
