<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE xsl:stylesheet
  PUBLIC "-//NetBSD//DTD NetBSD XSLT 1.0 DTD//EN"
         "http://www.NetBSD.org/XML/htdocs/share/xml/xslt10-netbsd.dtd">

<!-- $NetBSD: changes.xsl,v 1.7 2007/06/12 10:56:04 dsieger Exp $ -->

<!--

This file scans the given XML files for changes entries and prints links
to them. It assumes that every changes file has a webpage ID of the form
*changes-{X}, where {X} is the basename of the file.

The string parameter $changesdir must be given and point to the directory
where the changes files are located.

-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		version="1.0">

  <xsl:output encoding="ascii"/>
  <xsl:template match="webpage">
    <xsl:variable name="tmp_docid" select="substring-after(@id, 'changes-')"/>
    <xsl:variable name="docid">
      <xsl:if test="$tmp_docid != 'index'">
        <xsl:value-of select="concat($tmp_docid, '.html')"/>
      </xsl:if>
      <xsl:if test="$tmp_docid = 'index'">
        <xsl:value-of select="''"/>
      </xsl:if>
    </xsl:variable>
    <xsl:for-each select="sect1/sect2/sect3">
      <xsl:variable name="tmp_title" select="substring-after(title, '- ')"/>
      <xsl:variable name="date" select="substring-before(title, ' -')"/>
      <a>
        <xsl:attribute name="href">
          <xsl:value-of select="concat($changesdir, '/', $docid, '#', @id)"/>
        </xsl:attribute>
      <xsl:value-of select="$tmp_title"/>
      </a>
      <br />
      <xsl:value-of select="$date"/>
      <xsl:text>&#10;</xsl:text>
    </xsl:for-each>
  </xsl:template>
</xsl:stylesheet>
