#!/soft/bin/runhugs +l
-- Hey, Emacs, this is -*- haskell -*-
-- A simple "interactive" script   Erik Meijer (erik@cs.ruu.nl)

\begin{code}
module Main (main) where

import CGI
import Maybe(fromMaybe)

top_level :: String -> String
top_level = reverse . fst . break (== '.') . reverse

greetings :: String
greetings = "greetings.txt"

readGreetings :: IO [(String,String)]
readGreetings = catch (readFile greetings >>= readIO)
                      (\e -> return [("edu", "Hi there!"),
                                     ("de",  "Hallo, Deutschland!")])

hello :: [(Name,Value)] -> IO (CgiOut HTML)
hello env = do
   greetings <- readGreetings
   let site     = fromMaybe "unknown REMOTE_HOST" (lookup "REMOTE_HOST" env)
       greeting = fromMaybe "Hello World!" (lookup (top_level site) greetings)
   return Content{mime = page greeting [] [prose greeting] }

main :: IO ()
main = wrapper hello
\end{code}
