/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.rename;

import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.internal.files.PathPatternMatcher;
import org.eclipse.lsp4j.FileOperationFilter;
import org.eclipse.lsp4j.FileOperationOptions;
import org.eclipse.lsp4j.FileOperationPattern;
import org.eclipse.lsp4j.FileOperationsServerCapabilities;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.WorkspaceServerCapabilities;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;

public final class LSPFileOperationParticipantSupport {
    private static final long FILE_OP_TIMEOUT_SECONDS = 10L;

    static <P> @Nullable Change computePreChange(String changeName, P params, IResource resource, Function<FileOperationsServerCapabilities, @Nullable FileOperationOptions> optionsProvider, BiFunction<WorkspaceService, P, CompletableFuture<@Nullable WorkspaceEdit>> request) throws CoreException {
        return LSPFileOperationParticipantSupport.computePreChange(changeName, params, LSPFileOperationParticipantSupport.createFileOperationExecutor(resource, optionsProvider), request);
    }

    public static <P> @Nullable Change computePreChange(String changeName, P params, LanguageServers.LanguageServerProjectExecutor executor, BiFunction<WorkspaceService, P, CompletableFuture<@Nullable WorkspaceEdit>> request) throws CoreException {
        CompositeChange[] changes;
        CompletableFuture future = executor.collectAll((wrapper, ls) -> ((CompletableFuture)((CompletableFuture)request.apply(ls.getWorkspaceService(), params)).thenApply(edits -> edits == null || LSPFileOperationParticipantSupport.isEmptyEdit(edits) ? (CompositeChange)null : LSPEclipseUtils.toCompositeChange(edits, languageServerWrapper.serverDefinition.label))).orTimeout(10L, TimeUnit.SECONDS).exceptionally(ex -> {
            String logHeader = "File operation pre-change '" + changeName;
            if (ex instanceof TimeoutException) {
                LanguageServerPlugin.logWarning(logHeader + "' timed out for server: " + languageServerWrapper.serverDefinition.label + " after 10 seconds");
            } else {
                LanguageServerPlugin.logError(logHeader + "' failed for server: " + languageServerWrapper.serverDefinition.label, ex);
            }
            return null;
        }));
        try {
            changes = (CompositeChange[])future.get().stream().filter(Objects::nonNull).toArray(CompositeChange[]::new);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new CoreException((IStatus)new Status(4, "org.eclipse.lsp4e", "File operation pre-change '" + changeName + "' was interrupted", (Throwable)ex));
        }
        catch (ExecutionException ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.lsp4e", "File operation pre-change '" + changeName + "' failed", (Throwable)ex));
        }
        return switch (changes.length) {
            case 0 -> null;
            case 1 -> changes[0];
            default -> new CompositeChange(changeName, (Change[])changes);
        };
    }

    public static LanguageServers.LanguageServerProjectExecutor createFileOperationExecutor(IResource res, Function<FileOperationsServerCapabilities, @Nullable FileOperationOptions> optionsProvider) {
        URI uri = LSPEclipseUtils.toUri(res);
        IProject project = res.getProject();
        if (uri == null) {
            return (LanguageServers.LanguageServerProjectExecutor)LanguageServers.forProject(project).withFilter(capabilities -> false);
        }
        Path path = Path.of(uri);
        return (LanguageServers.LanguageServerProjectExecutor)LanguageServers.forProject(project).withFilter(capabilities -> {
            WorkspaceServerCapabilities workspace = capabilities.getWorkspace();
            if (workspace == null) {
                return false;
            }
            FileOperationsServerCapabilities fileOps = workspace.getFileOperations();
            if (fileOps == null) {
                return false;
            }
            FileOperationOptions options = (FileOperationOptions)optionsProvider.apply(fileOps);
            return LSPFileOperationParticipantSupport.matches(options, path, res.getType() == 2);
        });
    }

    private static boolean isEmptyEdit(WorkspaceEdit edits) {
        return !(edits.getChanges() != null && !edits.getChanges().isEmpty() || edits.getDocumentChanges() != null && !edits.getDocumentChanges().isEmpty());
    }

    private static boolean matches(@Nullable FileOperationOptions options, Path path, boolean isFolder) {
        if (options == null) {
            return false;
        }
        List filters = options.getFilters();
        return filters.isEmpty() || filters.stream().anyMatch(filter -> LSPFileOperationParticipantSupport.matchesFilter(filter, path, isFolder));
    }

    private static boolean matchesFilter(FileOperationFilter filter, Path path, boolean isFolder) {
        String scheme = filter.getScheme();
        if (scheme != null && !"file".equalsIgnoreCase(scheme)) {
            return false;
        }
        FileOperationPattern pattern = filter.getPattern();
        if (pattern.getGlob().isBlank()) {
            return false;
        }
        String matches = pattern.getMatches();
        if ("file".equals(matches) && isFolder) {
            return false;
        }
        if ("folder".equals(matches) && !isFolder) {
            return false;
        }
        String glob = pattern.getGlob();
        PathPatternMatcher matcher = new PathPatternMatcher(glob, null);
        return matcher.matches(path);
    }

    private LSPFileOperationParticipantSupport() {
    }
}

