/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dali.db.Connection;
import org.eclipse.dali.db.ConnectionListener;
import org.eclipse.dali.db.Database;
import org.eclipse.dali.db.Schema;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.orm.DiscriminatorColumn;
import org.eclipse.dali.orm.DiscriminatorType;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.PersistenceProject;
import org.eclipse.dali.orm.provider.DiscriminatorColumnItemProvider;
import org.eclipse.dali.orm.provider.OrmItemProviderAdapterFactory;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class DiscriminatorColumnComposite
extends Composite
implements IPersistenceComposite {
    private DiscriminatorColumn discriminatorColumn;
    private DiscriminatorColumnItemProvider discriminatorColumnItemProvider;
    private Connection connection;
    private ConnectionListener connectionListener;
    private INotifyChangedListener discriminatorColumnListener;
    protected EditingDomain editingDomain;
    private ComboViewer discriminatorTypeViewer;
    protected Combo columnCombo;
    protected boolean populating;
    static /* synthetic */ Class class$0;

    public DiscriminatorColumnComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.discriminatorColumnItemProvider = (DiscriminatorColumnItemProvider)adapterFactory.createDiscriminatorColumnAdapter();
        this.connectionListener = this.buildConnectionListener();
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        Label columnLabel = new Label((Composite)this, 16384);
        columnLabel.setText(DaliUiMessages.DiscriminatorColumnComposite_column);
        this.columnCombo = this.buildColumnCombo(this);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.columnCombo.setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.columnCombo, "org.eclipse.dali.ui.entity_inheritanceDiscriminatorColumn");
        Label discriminatorTypeLabel = new Label((Composite)this, 16384);
        discriminatorTypeLabel.setText(DaliUiMessages.DiscriminatorColumnComposite_discriminatorType);
        this.discriminatorTypeViewer = this.buildDiscriminatorTypeCombo(this);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.discriminatorTypeViewer.getCombo().setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.discriminatorTypeViewer.getCombo(), "org.eclipse.dali.ui.entity_inheritanceDiscriminatorType");
    }

    private Combo buildColumnCombo(Composite parent) {
        final Combo combo = new Combo(parent, 2052);
        combo.add(DaliUiMessages.DiscriminatorColumnComposite_defaultEmpty);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (DiscriminatorColumnComposite.this.populating) {
                    return;
                }
                String columnText = ((Combo)e.getSource()).getText();
                if (columnText.equals("")) {
                    columnText = null;
                    if (DiscriminatorColumnComposite.this.discriminatorColumn.getSpecifiedName() == null || DiscriminatorColumnComposite.this.discriminatorColumn.getSpecifiedName().equals("")) {
                        return;
                    }
                }
                if (columnText != null && combo.getItemCount() > 0 && columnText.equals(combo.getItem(0))) {
                    columnText = null;
                }
                if (DiscriminatorColumnComposite.this.discriminatorColumn.getSpecifiedName() == null || !DiscriminatorColumnComposite.this.discriminatorColumn.getSpecifiedName().equals(columnText)) {
                    DiscriminatorColumnComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)DiscriminatorColumnComposite.this.editingDomain, (Object)DiscriminatorColumnComposite.this.discriminatorColumn, (Object)OrmPackage.eINSTANCE.getDiscriminatorColumn_SpecifiedName(), (Object)columnText));
                }
            }
        });
        return combo;
    }

    private ComboViewer buildDiscriminatorTypeCombo(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.add(DiscriminatorType.VALUES.toArray());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (DiscriminatorColumnComposite.this.populating) {
                    return;
                }
                if (event.getSelection() instanceof StructuredSelection) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    DiscriminatorType discriminatorType = (DiscriminatorType)selection.getFirstElement();
                    if (!DiscriminatorColumnComposite.this.discriminatorColumn.getDiscriminatorType().equals(discriminatorType)) {
                        DiscriminatorColumnComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)DiscriminatorColumnComposite.this.editingDomain, (Object)DiscriminatorColumnComposite.this.discriminatorColumn, (Object)OrmPackage.eINSTANCE.getDiscriminatorColumn_DiscriminatorType(), (Object)discriminatorType));
                    }
                }
            }
        });
        return viewer;
    }

    private INotifyChangedListener getDiscriminatorColumnListener() {
        if (this.discriminatorColumnListener == null) {
            this.discriminatorColumnListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    DiscriminatorColumnComposite.this.discriminatorColumnChanged(notification);
                }
            };
        }
        return this.discriminatorColumnListener;
    }

    protected void discriminatorColumnChanged(Notification notification) {
        if (this.populating || notification.getNotifier() != this.discriminatorColumn) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.orm.DiscriminatorColumn");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (notification.getFeatureID((Class)clazz) == 1) {
            final String columnName = (String)notification.getNewValue();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (DiscriminatorColumnComposite.this.columnCombo.getText() == null || !DiscriminatorColumnComposite.this.columnCombo.getText().equals(columnName)) {
                        if (columnName == null) {
                            DiscriminatorColumnComposite.this.columnCombo.select(0);
                        } else {
                            DiscriminatorColumnComposite.this.columnCombo.setText(columnName);
                        }
                    }
                }
            });
        } else {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.dali.orm.DiscriminatorColumn");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (notification.getFeatureID((Class)clazz2) == 0) {
                final String defaultColumnName = (String)notification.getNewValue();
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        DiscriminatorColumnComposite.this.populating = true;
                        int selectionIndex = DiscriminatorColumnComposite.this.columnCombo.getSelectionIndex();
                        DiscriminatorColumnComposite.this.columnCombo.setItem(0, NLS.bind((String)DaliUiMessages.ColumnComposite_defaultWithOneParam, (Object)defaultColumnName));
                        if (selectionIndex == 0) {
                            DiscriminatorColumnComposite.this.columnCombo.select(0);
                        }
                        DiscriminatorColumnComposite.this.populating = false;
                    }
                });
            } else {
                Class<?> clazz3 = class$0;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$0 = Class.forName("org.eclipse.dali.orm.DiscriminatorColumn");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (notification.getFeatureID((Class)clazz3) == 3) {
                    final DiscriminatorType discriminatorType = (DiscriminatorType)notification.getNewValue();
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            if (((StructuredSelection)DiscriminatorColumnComposite.this.discriminatorTypeViewer.getSelection()).getFirstElement() != discriminatorType) {
                                DiscriminatorColumnComposite.this.discriminatorTypeViewer.setSelection((ISelection)new StructuredSelection((Object)discriminatorType));
                            }
                        }
                    });
                }
            }
        }
    }

    public void populate(EObject model) {
        this.populating = true;
        this.disengageListeners();
        this.discriminatorColumn = (DiscriminatorColumn)model;
        if (this.discriminatorColumn == null) {
            return;
        }
        this.engageListeners();
        this.populateColumnCombo();
        this.popuplateDiscriminatorTypeComboViewer();
        this.populating = false;
    }

    private void engageListeners() {
        this.discriminatorColumnItemProvider.addListener(this.getDiscriminatorColumnListener());
        this.discriminatorColumn.eAdapters().add((Object)this.discriminatorColumnItemProvider);
        this.addConnectionListener();
    }

    private void disengageListeners() {
        if (this.discriminatorColumn != null) {
            this.discriminatorColumn.eAdapters().remove((Object)this.discriminatorColumnItemProvider);
            this.discriminatorColumnItemProvider.removeListener(this.getDiscriminatorColumnListener());
            this.removeConnectionListener();
        }
    }

    private Table getTable() {
        return ((Entity)this.discriminatorColumn.getParent().getParent()).getResolvedDBTable();
    }

    private void populateColumnCombo() {
        String columnName = this.discriminatorColumn.getSpecifiedName();
        String defaultColumnName = this.discriminatorColumn.getDefaultName();
        this.columnCombo.setItem(0, NLS.bind((String)DaliUiMessages.ColumnComposite_defaultWithOneParam, (Object)defaultColumnName));
        PersistenceProject persistenceProject = this.discriminatorColumn.getPersistenceProject();
        Connection connection = persistenceProject.getConnection();
        if (connection.isConnected()) {
            this.columnCombo.remove(1, this.columnCombo.getItemCount() - 1);
            Table table = this.getTable();
            if (table != null) {
                Iterator i = CollectionTools.sort((List)CollectionTools.list((Iterator)table.columnNames())).iterator();
                while (i.hasNext()) {
                    this.columnCombo.add((String)i.next());
                }
            }
        } else {
            this.columnCombo.remove(1, this.columnCombo.getItemCount() - 1);
        }
        if (columnName != null) {
            if (!this.columnCombo.getText().equals(columnName)) {
                this.columnCombo.setText(columnName);
            }
        } else if (!this.columnCombo.getText().equals(NLS.bind((String)DaliUiMessages.ColumnComposite_defaultWithOneParam, (Object)defaultColumnName))) {
            this.columnCombo.select(0);
        }
    }

    private void popuplateDiscriminatorTypeComboViewer() {
        if (this.discriminatorColumn.getDiscriminatorType() == DiscriminatorType.DEFAULT_LITERAL) {
            if (((StructuredSelection)this.discriminatorTypeViewer.getSelection()).getFirstElement() != DiscriminatorType.DEFAULT_LITERAL) {
                this.discriminatorTypeViewer.setSelection((ISelection)new StructuredSelection((Object)DiscriminatorType.DEFAULT_LITERAL));
            }
        } else if (this.discriminatorColumn.getDiscriminatorType() == DiscriminatorType.CHAR_LITERAL) {
            if (((StructuredSelection)this.discriminatorTypeViewer.getSelection()).getFirstElement() != DiscriminatorType.CHAR_LITERAL) {
                this.discriminatorTypeViewer.setSelection((ISelection)new StructuredSelection((Object)DiscriminatorType.CHAR_LITERAL));
            }
        } else if (this.discriminatorColumn.getDiscriminatorType() == DiscriminatorType.INTEGER_LITERAL) {
            if (((StructuredSelection)this.discriminatorTypeViewer.getSelection()).getFirstElement() != DiscriminatorType.INTEGER_LITERAL) {
                this.discriminatorTypeViewer.setSelection((ISelection)new StructuredSelection((Object)DiscriminatorType.INTEGER_LITERAL));
            }
        } else if (((StructuredSelection)this.discriminatorTypeViewer.getSelection()).getFirstElement() != DiscriminatorType.STRING_LITERAL) {
            this.discriminatorTypeViewer.setSelection((ISelection)new StructuredSelection((Object)DiscriminatorType.STRING_LITERAL));
        }
    }

    public void dispose() {
        this.disengageListeners();
        super.dispose();
    }

    private void addConnectionListener() {
        this.connection = this.discriminatorColumn.getPersistenceProject().getConnection();
        this.connection.addConnectionListener(this.connectionListener);
    }

    private void removeConnectionListener() {
        this.connection.removeConnectionListener(this.connectionListener);
        this.connection = null;
    }

    private ConnectionListener buildConnectionListener() {
        return new ConnectionListener(){

            public void connectionInfoRenamed(String previousName, Connection connection) {
            }

            public void connected(Connection connection) {
            }

            public void disconnected(Connection connection) {
            }

            public void sharedConnectionAdded(Connection connection) {
            }

            public void sharedConnectionRemove(Connection connection) {
            }

            public void schemaChanged(Schema schema) {
                DiscriminatorColumnComposite.this.populateColumnCombo();
            }

            public void tableChanged(Table table) {
                DiscriminatorColumnComposite.this.populateColumnCombo();
            }

            public void databaseAdded(Connection connection, Database database) {
                DiscriminatorColumnComposite.this.populateColumnCombo();
            }

            public void databaseRemove(Connection connection, Database database) {
                DiscriminatorColumnComposite.this.populateColumnCombo();
            }

            public void onSQLException(Connection connection, SQLException exception) {
            }
        };
    }
}

