/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import org.eclipse.dali.orm.AttributeOverride;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.provider.AttributeOverrideItemProvider;
import org.eclipse.dali.orm.provider.EntityItemProvider;
import org.eclipse.dali.orm.provider.OrmItemProviderAdapterFactory;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.views.ColumnComposite;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class AttributeOverridesComposite
extends Composite
implements IPersistenceComposite {
    private ListViewer listViewer;
    private Entity entity;
    private INotifyChangedListener entityListener;
    private AttributeOverride attributeOverride;
    private INotifyChangedListener attributeOverrideItemListener;
    private EntityItemProvider entityItemProvider;
    private AttributeOverrideItemProvider attributeOverrideItemProvider;
    protected ColumnComposite columnComposite;
    private EditingDomain editingDomain;
    private OrmItemProviderAdapterFactory adapterFactory;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public AttributeOverridesComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.adapterFactory = adapterFactory;
        this.entityItemProvider = (EntityItemProvider)adapterFactory.createEntityAdapter();
        this.attributeOverrideItemProvider = (AttributeOverrideItemProvider)adapterFactory.createAttributeOverrideAdapter();
        this.initializeLayout();
    }

    private void initializeLayout() {
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        Group attributeOverridesGroup = new Group((Composite)this, 16);
        attributeOverridesGroup.setText(DaliUiMessages.AttributeOverridesComposite_attributeOverrides);
        attributeOverridesGroup.setLayout((Layout)new GridLayout(2, true));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        attributeOverridesGroup.setLayoutData((Object)gridData);
        this.listViewer = this.buildAttributeOverridesListViewer((Composite)attributeOverridesGroup);
        gridData = new GridData();
        gridData.verticalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.listViewer.getList().setLayoutData((Object)gridData);
        helpSystem.setHelp((Control)this.listViewer.getList(), "org.eclipse.dali.ui.entity_attributeOverrides");
        this.columnComposite = new ColumnComposite((Composite)attributeOverridesGroup, this.editingDomain, this.adapterFactory, "org.eclipse.dali.ui.entity_attributeOverridesColumn");
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.columnComposite.setLayoutData(gridData);
    }

    private ListViewer buildAttributeOverridesListViewer(Composite parent) {
        ListViewer listViewer = new ListViewer(parent, 2052);
        listViewer.setLabelProvider((IBaseLabelProvider)this.buildAttributeOverridesLabelProvider());
        listViewer.setContentProvider(this.buildAttributeOverridesContentProvider());
        listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AttributeOverridesComposite.this.attributeOverridesListSelectionChanged(event);
            }
        });
        return listViewer;
    }

    protected void attributeOverridesListSelectionChanged(SelectionChangedEvent event) {
        if (((StructuredSelection)event.getSelection()).isEmpty()) {
            this.columnComposite.populate(null);
            this.columnComposite.enableWidgets(false);
            if (this.attributeOverride != null) {
                this.attributeOverride.eAdapters().remove((Object)this.attributeOverrideItemProvider);
                this.attributeOverride = null;
            }
        } else {
            this.attributeOverride = this.getSelectedAttributeOverride();
            this.columnComposite.populate((EObject)this.attributeOverride.getColumn());
            this.columnComposite.enableWidgets(true);
            this.attributeOverride.eAdapters().add((Object)this.attributeOverrideItemProvider);
        }
    }

    private ILabelProvider buildAttributeOverridesLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                return ((AttributeOverride)element).getName();
            }
        };
    }

    private IContentProvider buildAttributeOverridesContentProvider() {
        return new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((Entity)inputElement).getAttributeOverrides().toArray();
            }
        };
    }

    private AttributeOverride getSelectedAttributeOverride() {
        return (AttributeOverride)((StructuredSelection)this.listViewer.getSelection()).getFirstElement();
    }

    public void populate(EObject entity) {
        this.disengageListeners();
        this.entity = (Entity)entity;
        if (this.entity == null) {
            this.attributeOverride = null;
            this.columnComposite.populate(null);
            return;
        }
        this.engageListeners();
        if (this.listViewer.getInput() != entity) {
            this.listViewer.setInput((Object)entity);
        }
        if (!this.entity.getAttributeOverrides().isEmpty()) {
            if (this.listViewer.getSelection().isEmpty()) {
                this.listViewer.setSelection((ISelection)new StructuredSelection(this.entity.getAttributeOverrides().get(0)));
            } else {
                this.columnComposite.enableWidgets(true);
                this.columnComposite.populate((EObject)((AttributeOverride)((StructuredSelection)this.listViewer.getSelection()).getFirstElement()).getColumn());
            }
        } else {
            this.columnComposite.populate(null);
            this.columnComposite.enableWidgets(false);
        }
    }

    private void engageListeners() {
        this.attributeOverrideItemProvider.addListener(this.getAttributeOverrideItemListener());
        this.entityItemProvider.addListener(this.getEntityListener());
        this.entity.eAdapters().add((Object)this.entityItemProvider);
    }

    private void disengageListeners() {
        if (this.entity != null) {
            this.entity.eAdapters().remove((Object)this.entityItemProvider);
            this.entityItemProvider.removeListener(this.getEntityListener());
            this.attributeOverrideItemProvider.removeListener(this.getAttributeOverrideItemListener());
            if (this.attributeOverride != null) {
                this.attributeOverride.eAdapters().remove((Object)this.attributeOverrideItemProvider);
            }
        }
    }

    private INotifyChangedListener getEntityListener() {
        if (this.entityListener == null) {
            this.entityListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    AttributeOverridesComposite.this.entityChanged(notification);
                }
            };
        }
        return this.entityListener;
    }

    protected void entityChanged(Notification notification) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.orm.Entity");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        switch (notification.getFeatureID((Class)clazz)) {
            case 6: {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        AttributeOverridesComposite.this.listViewer.refresh();
                        AttributeOverridesComposite.this.columnComposite.enableWidgets(!AttributeOverridesComposite.this.listViewer.getSelection().isEmpty());
                        if (AttributeOverridesComposite.this.listViewer.getSelection().isEmpty()) {
                            AttributeOverridesComposite.this.columnComposite.populate(null);
                        }
                    }
                });
                if (notification.getEventType() != 3) break;
                final Object newValue = notification.getNewValue();
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        AttributeOverridesComposite.this.listViewer.setSelection((ISelection)new StructuredSelection(newValue));
                    }
                });
                break;
            }
        }
    }

    private INotifyChangedListener getAttributeOverrideItemListener() {
        if (this.attributeOverrideItemListener == null) {
            this.attributeOverrideItemListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    AttributeOverridesComposite.this.attributeOverrideChanged(notification);
                }
            };
        }
        return this.attributeOverrideItemListener;
    }

    protected void attributeOverrideChanged(Notification notification) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.dali.orm.AttributeOverride");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        switch (notification.getFeatureID((Class)clazz)) {
            case 0: {
                final AttributeOverride attributeOverride = (AttributeOverride)notification.getNotifier();
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        AttributeOverridesComposite.this.listViewer.refresh((Object)attributeOverride);
                    }
                });
                break;
            }
        }
    }

    public void dispose() {
        this.disengageListeners();
        this.columnComposite.dispose();
        super.dispose();
    }
}

