/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.db.ddl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dali.db.Connection;
import org.eclipse.dali.db.ddl.TableComparator;
import org.eclipse.dali.internal.utility.JDBCTools;
import org.eclipse.dali.orm.AttributeMapping;
import org.eclipse.dali.orm.ColumnHolder;
import org.eclipse.dali.orm.IdMapping;
import org.eclipse.dali.orm.JoinColumn;
import org.eclipse.dali.orm.JoinTable;
import org.eclipse.dali.orm.ManyToManyMapping;
import org.eclipse.dali.orm.NonOwningMapping;
import org.eclipse.dali.orm.PersistenceContainer;
import org.eclipse.dali.orm.PersistenceFile;
import org.eclipse.dali.orm.PersistenceProject;
import org.eclipse.dali.orm.PersistenceResource;
import org.eclipse.dali.orm.PersistentAttribute;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.RelationshipMapping;
import org.eclipse.dali.orm.SingleRelationshipMapping;
import org.eclipse.dali.orm.Table;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.adapters.IPersistenceModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaPersistentAttributeModelAdapter;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.rdb.fe.internal.ui.wizards.FEWizard;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.models.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.wst.rdb.internal.models.sql.constraints.PrimaryKey;
import org.eclipse.wst.rdb.internal.models.sql.constraints.SQLConstraintsPackage;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.DataType;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.PredefinedDataType;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.SQLDataType;
import org.eclipse.wst.rdb.internal.models.sql.expressions.ValueExpression;
import org.eclipse.wst.rdb.internal.models.sql.expressions.ValueExpressionDefault;
import org.eclipse.wst.rdb.internal.models.sql.expressions.impl.SQLExpressionsFactoryImpl;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLSchemaFactory;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;
import org.eclipse.wst.rdb.internal.models.sql.tables.Column;
import org.eclipse.wst.rdb.internal.models.sql.tables.PersistentTable;
import org.eclipse.wst.rdb.internal.models.sql.tables.SQLTablesFactory;

public class DDLGenerator {
    private final PersistenceProject persistenceProject;
    private final DatabaseDefinition databaseDefinition;
    private final Database database;
    private final Schema defaultSchema;
    private final IProgressMonitor progressMonitor;

    public static void generateDDL(PersistenceProject persistenceProject, IProgressMonitor progressMonitor) throws CoreException {
        new DDLGenerator(persistenceProject, progressMonitor).generateDDL();
    }

    private DDLGenerator(PersistenceProject persistenceProject, IProgressMonitor monitor) {
        this.persistenceProject = persistenceProject;
        this.databaseDefinition = this.buildDatabaseDefinition();
        this.database = this.buildDatabase();
        this.defaultSchema = this.buildDefaultSchema();
        this.database.getSchemas().add((Object)this.defaultSchema);
        this.progressMonitor = monitor;
    }

    private DatabaseDefinition buildDatabaseDefinition() {
        Connection conn = this.persistenceProject.getConnection();
        return RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(conn.getDatabaseProduct(), conn.getDatabaseVersion());
    }

    private Database buildDatabase() {
        Database db = SQLSchemaFactory.eINSTANCE.createDatabase();
        db.setVendor(this.databaseDefinition.getProduct());
        db.setVersion(this.databaseDefinition.getVersion());
        return db;
    }

    private Schema buildDefaultSchema() {
        return SQLSchemaFactory.eINSTANCE.createSchema();
    }

    private void generateDDL() throws CoreException {
        Collection pFiles = this.buildPersistenceFiles();
        this.progressMonitor.beginTask("Building table definitions", pFiles.size() * 2);
        this.addBasicColumns(pFiles);
        this.addReferenceColumns(pFiles);
        this.progressMonitor.done();
        this.openForwardEngineerWizard();
    }

    private void addBasicColumns(Collection pFiles) {
        Iterator stream = pFiles.iterator();
        while (stream.hasNext()) {
            this.addBasicColumns((PersistenceFile)stream.next());
            this.progressMonitor.worked(1);
        }
    }

    private void addBasicColumns(PersistenceFile pFile) {
        Iterator stream = pFile.getPersistentTypes().iterator();
        while (stream.hasNext()) {
            this.addBasicColumns((PersistentType)stream.next());
        }
    }

    private void addBasicColumns(PersistentType pType) {
        TypeMapping typeMapping = pType.getTypeMapping();
        Table ormTable = typeMapping.getTable();
        if (ormTable == null) {
            return;
        }
        ArrayList primaryTablePKColumns = new ArrayList(3);
        Iterator stream = pType.getPersistentAttributes().iterator();
        while (stream.hasNext()) {
            this.addBasicColumns((PersistentAttribute)stream.next(), primaryTablePKColumns);
        }
        this.configurePrimaryKeyConstraint(ormTable, primaryTablePKColumns);
    }

    private void addBasicColumns(PersistentAttribute pAttribute, Collection primaryTablePKColumns) {
        AttributeMapping attributeMapping = pAttribute.getAttributeMapping();
        if (attributeMapping instanceof ColumnHolder) {
            this.addBasicColumns(pAttribute, primaryTablePKColumns, (ColumnHolder)attributeMapping);
        }
    }

    private void addBasicColumns(PersistentAttribute pAttribute, Collection primaryTablePKColumns, ColumnHolder columnHolder) {
        org.eclipse.dali.orm.Column ormColumn = columnHolder.getColumn();
        Column rdbColumn = this.rdbColumn(pAttribute.getTypeMapping(), ormColumn);
        if (rdbColumn == null) {
            return;
        }
        int jdbcType = this.jdbcType(pAttribute);
        this.configureRDBColumn(rdbColumn, ormColumn, jdbcType);
        if (columnHolder instanceof IdMapping) {
            primaryTablePKColumns.add(rdbColumn);
        }
    }

    private void configureRDBColumn(Column rdbColumn, org.eclipse.dali.orm.Column ormColumn, int jdbcType) {
        rdbColumn.setName(ormColumn.getName());
        String columnDefinition = ormColumn.getColumnDefinition();
        if (columnDefinition != null && columnDefinition.length() > 0) {
            ValueExpressionDefault expression = SQLExpressionsFactoryImpl.eINSTANCE.createValueExpressionDefault();
            expression.setSQL(columnDefinition);
            rdbColumn.setGenerateExpression((ValueExpression)expression);
        }
        rdbColumn.setNullable(ormColumn.isNullable());
        List dataTypeDefs = this.databaseDefinition.getPredefinedDataTypeDefinitionsByJDBCEnumType(jdbcType);
        if (dataTypeDefs.size() == 0) {
            dataTypeDefs = this.databaseDefinition.getPredefinedDataTypeDefinitionsByJDBCEnumType(12);
        }
        if (dataTypeDefs.size() > 0) {
            EStructuralFeature feature;
            PredefinedDataTypeDefinition dataTypeDef = (PredefinedDataTypeDefinition)dataTypeDefs.get(0);
            PredefinedDataType dataType = this.databaseDefinition.getPredefinedDataType(dataTypeDef);
            if (dataTypeDef.isLengthSupported()) {
                feature = dataType.eClass().getEStructuralFeature("length");
                dataType.eSet(feature, (Object)new Integer(ormColumn.getLength()));
            }
            if (dataTypeDef.isPrecisionSupported()) {
                feature = dataType.eClass().getEStructuralFeature("precision");
                dataType.eSet(feature, (Object)new Integer(ormColumn.getPrecision()));
            }
            if (dataTypeDef.isScaleSupported()) {
                feature = dataType.eClass().getEStructuralFeature("scale");
                dataType.eSet(feature, (Object)new Integer(ormColumn.getScale()));
            }
            rdbColumn.setContainedType((SQLDataType)dataType);
        }
    }

    private void configurePrimaryKeyConstraint(Table ormTable, Collection primaryTablePKColumns) {
        if (primaryTablePKColumns.isEmpty()) {
            return;
        }
        EClass primaryKeyClass = SQLConstraintsPackage.eINSTANCE.getPrimaryKey();
        PrimaryKey pk = (PrimaryKey)this.databaseDefinition.getDataModelElementFactory().create(primaryKeyClass);
        pk.setName(String.valueOf(ormTable.getName()) + "_PK");
        pk.getMembers().addAll(primaryTablePKColumns);
        this.rdbTable(ormTable).getConstraints().add((Object)pk);
    }

    private void addReferenceColumns(Collection pFiles) {
        Iterator stream = pFiles.iterator();
        while (stream.hasNext()) {
            this.addReferenceColumns((PersistenceFile)stream.next());
            this.progressMonitor.worked(1);
        }
    }

    private void addReferenceColumns(PersistenceFile pFile) {
        Iterator stream = pFile.getPersistentTypes().iterator();
        while (stream.hasNext()) {
            this.addReferenceColumns((PersistentType)stream.next());
        }
    }

    private void addReferenceColumns(PersistentType pType) {
        TypeMapping typeMapping = pType.getTypeMapping();
        Table ormTable = typeMapping.getTable();
        if (ormTable == null) {
            return;
        }
        Iterator stream = pType.getPersistentAttributes().iterator();
        while (stream.hasNext()) {
            this.addReferenceColumns((PersistentAttribute)stream.next());
        }
    }

    private void addReferenceColumns(PersistentAttribute pAttribute) {
        AttributeMapping attributeMapping = pAttribute.getAttributeMapping();
        if (!(attributeMapping instanceof RelationshipMapping)) {
            return;
        }
        RelationshipMapping relMapping = (RelationshipMapping)attributeMapping;
        if (relMapping instanceof NonOwningMapping && ((NonOwningMapping)relMapping).getMappedBy() != null) {
            return;
        }
        String targetEntityName = relMapping.getTargetEntity();
        PersistentType targetType = pAttribute.getPersistenceFile().resolvePersistentType(targetEntityName);
        if (targetType == null) {
            return;
        }
        Table ormTargetTable = targetType.getTypeMapping().getTable();
        if (ormTargetTable == null) {
            return;
        }
        if (relMapping instanceof SingleRelationshipMapping) {
            this.addReferenceColumns((SingleRelationshipMapping)relMapping, ormTargetTable);
        } else if (relMapping instanceof ManyToManyMapping) {
            this.addReferenceColumns((ManyToManyMapping)relMapping, ormTargetTable);
        }
    }

    private void addReferenceColumns(SingleRelationshipMapping mapping, Table ormTargetTable) {
        Iterator stream = mapping.getJoinColumns().iterator();
        while (stream.hasNext()) {
            this.addJoinColumn(mapping.getTypeMapping(), (JoinColumn)stream.next(), ormTargetTable);
        }
    }

    private void addJoinColumn(TypeMapping typeMapping, JoinColumn joinColumn, Table ormTargetTable) {
        Column rdbJoinColumn = this.rdbColumn(typeMapping, joinColumn);
        Column rdbReferencedColumn = this.rdbColumn(ormTargetTable, joinColumn.getReferencedColumnName());
        this.copyDataType(rdbJoinColumn, rdbReferencedColumn);
    }

    private void addReferenceColumns(ManyToManyMapping mapping, Table ormTargetTable) {
        Column rdbReferencedColumn;
        Column rdbJoinColumn;
        JoinColumn joinColumn;
        JoinTable ormJoinTable = mapping.getJoinTable();
        if (ormJoinTable == null) {
            return;
        }
        Iterator stream = ormJoinTable.getJoinColumns().iterator();
        while (stream.hasNext()) {
            joinColumn = (JoinColumn)stream.next();
            rdbJoinColumn = this.rdbColumn((Table)ormJoinTable, joinColumn.getName());
            rdbReferencedColumn = this.rdbColumn(mapping.getTypeMapping().getTable(), joinColumn.getReferencedColumnName());
            this.copyDataType(rdbJoinColumn, rdbReferencedColumn);
        }
        stream = ormJoinTable.getInverseJoinColumns().iterator();
        while (stream.hasNext()) {
            joinColumn = (JoinColumn)stream.next();
            rdbJoinColumn = this.rdbColumn((Table)ormJoinTable, joinColumn.getName());
            rdbReferencedColumn = this.rdbColumn(ormTargetTable, joinColumn.getReferencedColumnName());
            this.copyDataType(rdbJoinColumn, rdbReferencedColumn);
        }
    }

    private void copyDataType(Column destination, Column source) {
        EStructuralFeature feature;
        DataType sourceDataType = source.getDataType();
        if (sourceDataType == null) {
            return;
        }
        PredefinedDataTypeDefinition dataTypeDef = this.databaseDefinition.getPredefinedDataTypeDefinition(sourceDataType.getName());
        if (dataTypeDef == null) {
            return;
        }
        PredefinedDataType destinationDataType = this.databaseDefinition.getPredefinedDataType(dataTypeDef);
        if (dataTypeDef.isLengthSupported()) {
            feature = destinationDataType.eClass().getEStructuralFeature("length");
            destinationDataType.eSet(feature, sourceDataType.eGet(feature));
        }
        if (dataTypeDef.isPrecisionSupported()) {
            feature = destinationDataType.eClass().getEStructuralFeature("precision");
            destinationDataType.eSet(feature, sourceDataType.eGet(feature));
        }
        if (dataTypeDef.isScaleSupported()) {
            feature = destinationDataType.eClass().getEStructuralFeature("scale");
            destinationDataType.eSet(feature, sourceDataType.eGet(feature));
        }
        destination.setContainedType((SQLDataType)destinationDataType);
    }

    private void openForwardEngineerWizard() {
        ArrayList tables = new ArrayList(100);
        Iterator stream = this.database.getSchemas().iterator();
        while (stream.hasNext()) {
            tables.addAll(((Schema)stream.next()).getTables());
        }
        if (tables.isEmpty()) {
            return;
        }
        Collections.sort(tables, TableComparator.INSTANCE);
        FEWizard wizard = new FEWizard(tables);
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    private int jdbcType(PersistentAttribute pAttribute) {
        IPersistenceModelAdapter modelAdapter = pAttribute.getModelAdapter();
        if (modelAdapter instanceof JavaPersistentAttributeModelAdapter) {
            String packageName;
            JavaPersistentAttributeModelAdapter jma = (JavaPersistentAttributeModelAdapter)modelAdapter;
            String typeName = Signature.getSignatureSimpleName((String)jma.getAttribute().getTypeSignature());
            String qualifier = Signature.getSignatureQualifier((String)jma.getAttribute().getTypeSignature());
            if (qualifier.length() > 0) {
                typeName = String.valueOf(qualifier) + "." + typeName;
            }
            String[][] resolvedTypes = null;
            try {
                resolvedTypes = jma.getAttribute().getJDTMember().getDeclaringType().resolveType(typeName);
            }
            catch (JavaModelException ex) {
                throw new RuntimeException(ex);
            }
            if (resolvedTypes != null && resolvedTypes.length == 1 && (packageName = resolvedTypes[0][0]).length() > 0) {
                typeName = String.valueOf(packageName) + "." + resolvedTypes[0][1];
            }
            return JDBCTools.jdbcTypeForClassNamed((String)typeName).getCode();
        }
        return 12;
    }

    private Collection buildPersistenceFiles() throws CoreException {
        this.persistenceProject.buildResources();
        ArrayList files = new ArrayList(100);
        this.addPersistenceFilesTo((PersistenceContainer)this.persistenceProject, files);
        return files;
    }

    private void addPersistenceFilesTo(PersistenceContainer container, Collection files) throws CoreException {
        Iterator stream = container.getPersistenceResources().iterator();
        while (stream.hasNext()) {
            this.addPersistenceFilesTo((PersistenceResource)stream.next(), files);
        }
    }

    private void addPersistenceFilesTo(PersistenceResource resource, Collection files) throws CoreException {
        if (resource instanceof PersistenceContainer) {
            this.addPersistenceFilesTo((PersistenceContainer)resource, files);
        } else if (resource instanceof PersistenceFile) {
            files.add(resource);
        }
    }

    private Schema rdbSchema(String schemaName) {
        if (schemaName == null || schemaName.length() == 0) {
            return this.defaultSchema;
        }
        Iterator stream = this.database.getSchemas().iterator();
        while (stream.hasNext()) {
            Schema rdbSchema = (Schema)stream.next();
            if (!rdbSchema.getName().equalsIgnoreCase(schemaName)) continue;
            return rdbSchema;
        }
        Schema rdbSchema = SQLSchemaFactory.eINSTANCE.createSchema();
        rdbSchema.setName(schemaName);
        this.database.getSchemas().add((Object)rdbSchema);
        return rdbSchema;
    }

    private PersistentTable rdbTable(Table ormTable) {
        return this.rdbTable(ormTable.getSchema(), ormTable.getName());
    }

    private PersistentTable rdbTable(String schemaName, String tableName) {
        Schema schema = this.rdbSchema(schemaName);
        Iterator stream = schema.getTables().iterator();
        while (stream.hasNext()) {
            PersistentTable tdbTable = (PersistentTable)stream.next();
            if (!tdbTable.getName().equalsIgnoreCase(tableName)) continue;
            return tdbTable;
        }
        PersistentTable tdbTable = SQLTablesFactory.eINSTANCE.createPersistentTable();
        tdbTable.setName(tableName);
        schema.getTables().add((Object)tdbTable);
        return tdbTable;
    }

    private PersistentTable rdbTable(TypeMapping typeMapping, String tableName) {
        Iterator stream = typeMapping.associatedTablesIncludingInherited();
        while (stream.hasNext()) {
            Table ormTable = (Table)stream.next();
            if (!ormTable.getName().equalsIgnoreCase(tableName)) continue;
            return this.rdbTable(ormTable);
        }
        return null;
    }

    private Column rdbColumn(TypeMapping typeMapping, org.eclipse.dali.orm.Column ormColumn) {
        return this.rdbColumn(typeMapping, ormColumn.getTableName(), ormColumn.getName());
    }

    private Column rdbColumn(TypeMapping typeMapping, JoinColumn ormJoinColumn) {
        return this.rdbColumn(typeMapping, ormJoinColumn.getTableName(), ormJoinColumn.getName());
    }

    private Column rdbColumn(TypeMapping typeMapping, String tableName, String columnName) {
        PersistentTable rdbTable = this.rdbTable(typeMapping, tableName);
        if (rdbTable == null) {
            return null;
        }
        return this.rdbColumn((org.eclipse.wst.rdb.internal.models.sql.tables.Table)rdbTable, columnName);
    }

    private Column rdbColumn(Table ormTable, String columnName) {
        return this.rdbColumn((org.eclipse.wst.rdb.internal.models.sql.tables.Table)this.rdbTable(ormTable), columnName);
    }

    private Column rdbColumn(org.eclipse.wst.rdb.internal.models.sql.tables.Table rdbTable, String columnName) {
        Iterator stream = rdbTable.getColumns().iterator();
        while (stream.hasNext()) {
            Column rdbColumn = (Column)stream.next();
            if (!rdbColumn.getName().equalsIgnoreCase(columnName)) continue;
            return rdbColumn;
        }
        Column rdbColumn = SQLTablesFactory.eINSTANCE.createColumn();
        rdbColumn.setName(columnName);
        rdbTable.getColumns().add((Object)rdbColumn);
        return rdbColumn;
    }
}

