/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import org.eclipse.dali.orm.JoinColumn;
import org.eclipse.dali.orm.Updatable;
import org.eclipse.dali.orm.adapters.java.JoinColumnInfoAdapter;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.dali.orm.adapters.java.SingularOrPluralBooleanAnnotationElementAdapter;

public class JoinColumnUpdatableInfo
implements SingularOrPluralBooleanAnnotationElementAdapter.Info {
    private final JoinColumnInfoAdapter adapter;

    public JoinColumnUpdatableInfo(JoinColumnInfoAdapter adapter) {
        this.adapter = adapter;
    }

    public String annotationElementName() {
        return "updatable";
    }

    public String annotationName() {
        return "JoinColumn";
    }

    public String defaultValue() {
        return null;
    }

    public Member member() {
        return this.adapter.member();
    }

    public String persValue() {
        switch (this.joinColumn().getUpdatable().getValue()) {
            case 1: {
                return "true";
            }
            case 2: {
                return "false";
            }
        }
        return null;
    }

    public boolean removeAnnotationIfEmpty() {
        return true;
    }

    public void setPersValue(String newValue) {
        if (newValue == null) {
            this.joinColumn().setUpdatable(Updatable.DEFAULT_LITERAL);
        } else if (newValue.equals("true")) {
            this.joinColumn().setUpdatable(Updatable.TRUE_LITERAL);
        } else if (newValue.equals("false")) {
            this.joinColumn().setUpdatable(Updatable.FALSE_LITERAL);
        }
    }

    public int persIndex() {
        return this.joinColumn().indexInContainer();
    }

    public String pluralAnnotationName() {
        return "JoinColumns";
    }

    private JoinColumn joinColumn() {
        return this.adapter.joinColumn();
    }
}

