/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.perspective.view;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vorto.core.api.model.model.ModelId;
import org.eclipse.vorto.core.api.repository.ModelResource;
import org.eclipse.vorto.core.api.repository.UploadResult;
import org.eclipse.vorto.perspective.util.ImageUtil;

public class ModelUploadDialog
extends TitleAreaDialog {
    private static final String UNAVAILABLE_ICON = "signed_no.gif";
    private static final String AVAILABLE_ICON = "signed_yes.gif";
    private static final String REFERENCES_LABEL = "References";
    private static final String DESCRIPTION_LABEL = "Description";
    private static final String DISPLAY_NAME_LABEL = "DisplayName";
    private static final String MODELTYPE_LABEL = "Modeltype";
    private static final String VERSION_LABEL = "Version";
    private static final String NAME_LABEL = "Name";
    private static final String NAMESPACE_LABEL = "Namespace";
    private static final String WINDOW_TITLE = "Share Model";
    private static final String ERROR_MSG = "ERROR - ";
    private static final String SUCCESS_MSG = "OK - Uploaded model is valid and ready to be checked in.";
    private static final String[] COLUMNS = new String[]{"", "Name", "Namespace", "Version"};
    private UploadResult uploadResult;

    public ModelUploadDialog(Shell parentShell, UploadResult uploadResult) {
        super(parentShell);
        this.uploadResult = Objects.requireNonNull(uploadResult, "uploadResult should not be null");
    }

    public void create() {
        super.create();
        this.setTitle(WINDOW_TITLE);
        if (this.uploadResult.statusOk()) {
            this.setMessage(SUCCESS_MSG, 1);
        } else {
            this.setMessage(ERROR_MSG + this.uploadResult.getErrorMessage(), 3);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        String namespace = null;
        String name = null;
        String version = null;
        String modelType = null;
        String displayName = null;
        String description = null;
        ModelResource modelResource = this.uploadResult.getModelResource();
        if (modelResource != null) {
            ModelId id = modelResource.getId();
            if (id != null) {
                namespace = id.getNamespace();
                name = id.getName();
                version = id.getVersion();
                modelType = id.getModelType().toString();
            }
            displayName = modelResource.getDisplayName();
            description = modelResource.getDescription();
        }
        this.createField(container, NAMESPACE_LABEL, namespace);
        this.createField(container, NAME_LABEL, name);
        this.createField(container, VERSION_LABEL, version);
        this.createField(container, MODELTYPE_LABEL, modelType);
        this.createField(container, DISPLAY_NAME_LABEL, displayName);
        this.createField(container, DESCRIPTION_LABEL, description);
        this.createReferencesTable(container, modelResource.getReferences());
        return composite;
    }

    private void createField(Composite container, String label, String value) {
        Label lbtFirstName = new Label(container, 0);
        lbtFirstName.setText(label);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        Text text = new Text(container, 2048);
        text.setLayoutData((Object)data);
        text.setText(Strings.nullToEmpty((String)value));
        text.setEditable(false);
    }

    private void createReferencesTable(Composite container, List<ModelId> references) {
        Label lbtFirstName = new Label(container, 0);
        lbtFirstName.setText(REFERENCES_LABEL);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        Table table = new Table(container, 2816);
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        String[] stringArray = COLUMNS;
        int n = COLUMNS.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            TableColumn column = new TableColumn(table, 0);
            column.setText(columnName);
            ++n2;
        }
        if (references != null) {
            for (ModelId id : references) {
                TableItem item = new TableItem(table, 0);
                item.setImage(0, this.getImage(id));
                item.setImage(1, ImageUtil.getImageForModelType(id.getModelType()));
                item.setText(1, id.getName());
                item.setText(2, id.getNamespace());
                item.setText(3, id.getVersion());
            }
        }
        int i = 0;
        while (i < COLUMNS.length) {
            table.getColumn(i).pack();
            ++i;
        }
    }

    private Image getImage(ModelId model) {
        String imgFile = AVAILABLE_ICON;
        if (this.uploadResult.getUnresolvedReferences() != null) {
            for (ModelId unresolvedModel : this.uploadResult.getUnresolvedReferences()) {
                if (!this.same(model, unresolvedModel)) continue;
                imgFile = UNAVAILABLE_ICON;
            }
        }
        return ImageUtil.getImage(imgFile);
    }

    private boolean same(ModelId modelId1, ModelId modelId2) {
        return modelId2.getName().equals(modelId1.getName()) && modelId2.getNamespace().equals(modelId1.getNamespace()) && modelId2.getVersion().equals(modelId1.getVersion());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setText("Share");
        if (this.uploadResult.statusOk()) {
            this.getButton(0).setEnabled(true);
        } else {
            this.getButton(0).setEnabled(false);
        }
    }
}

