/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.kura.templates.bluetooth;

import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.kura.templates.Utils;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class DeviceTemplate
implements IFileTemplate<InformationModel> {
    public String getFileName(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = context.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"Device.java");
        return _builder.toString();
    }

    public String getPath(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        String _javaPackageBasePath = Utils.getJavaPackageBasePath();
        _builder.append((Object)_javaPackageBasePath, "");
        return _builder.toString();
    }

    public String getContent(InformationModel element, InvocationContext context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        String _javaPackage = Utils.getJavaPackage();
        _builder.append((Object)_javaPackage, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.kura.KuraException;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.kura.bluetooth.BluetoothDevice;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.kura.bluetooth.BluetoothGatt;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.kura.bluetooth.BluetoothGattSecurityLevel;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.kura.bluetooth.BluetoothLeNotificationListener;");
        _builder.newLine();
        _builder.append((Object)"import org.slf4j.Logger;");
        _builder.newLine();
        _builder.append((Object)"import org.slf4j.LoggerFactory;");
        _builder.newLine();
        _builder.newLine();
        EList _properties = element.getProperties();
        for (FunctionblockProperty fbProperty : _properties) {
            _builder.append((Object)"import ");
            String _javaPackage_1 = Utils.getJavaPackage();
            _builder.append((Object)_javaPackage_1, "");
            _builder.append((Object)".cloud.");
            FunctionblockModel _type = fbProperty.getType();
            String _name = _type.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _name_1 = element.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)"Device implements BluetoothLeNotificationListener {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private static final Logger logger = LoggerFactory.getLogger(");
        String _name_2 = element.getName();
        _builder.append((Object)_name_2, "\t");
        _builder.append((Object)"Device.class);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private BluetoothGatt bluetoothGatt;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private BluetoothDevice device;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private boolean isConnected;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_3 = element.getName();
        _builder.append((Object)_name_3, "\t");
        _builder.append((Object)"Device(BluetoothDevice bluetoothDevice) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.device = bluetoothDevice;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.isConnected = false;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void onDataReceived(String handle, String value) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (checkHandleIf");
        String _name_4 = element.getName();
        _builder.append((Object)_name_4, "\t\t");
        _builder.append((Object)"(handle)) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"            ");
        _builder.append((Object)"logger.info(\"Received ");
        String _name_5 = element.getName();
        _builder.append((Object)_name_5, "            ");
        _builder.append((Object)" data: \" + value);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private boolean checkHandleIf");
        String _name_6 = element.getName();
        _builder.append((Object)_name_6, "\t");
        _builder.append((Object)"(String handle) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return false;//TODO: add condition to check if data comes from ");
        String _name_7 = element.getName();
        _builder.append((Object)_name_7, "\t\t");
        _builder.append((Object)" device");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void disconnect() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (this.bluetoothGatt != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"this.bluetoothGatt.disconnect();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"this.isConnected = false;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public BluetoothDevice getBluetoothDevice() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this.device;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void setBluetoothDevice(BluetoothDevice device) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.device = device;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public boolean isConnected() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.isConnected = checkConnection();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this.isConnected;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public boolean checkConnection() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (this.bluetoothGatt != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"boolean connected = false;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"connected = this.bluetoothGatt.checkConnection();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"} catch (KuraException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"logger.error(e.toString());");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (connected) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"this.isConnected = true;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"return true;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"// If connect command is not executed, close gatttool");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"this.bluetoothGatt.disconnect();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"this.isConnected = false;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"return false;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"this.isConnected = false;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return false;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void setSecurityLevel(BluetoothGattSecurityLevel level) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (this.bluetoothGatt != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"this.bluetoothGatt.setSecurityLevel(level);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public BluetoothGattSecurityLevel getSecurityLevel() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"BluetoothGattSecurityLevel level = BluetoothGattSecurityLevel.UNKNOWN;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (this.bluetoothGatt != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"level = this.bluetoothGatt.getSecurityLevel();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (KuraException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.error(\"Get security level failed\", e);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return level;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        EList _properties_1 = element.getProperties();
        for (FunctionblockProperty fbProperty_1 : _properties_1) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            FunctionblockModel _type_1 = fbProperty_1.getType();
            String _name_8 = _type_1.getName();
            _builder.append((Object)_name_8, "\t");
            _builder.append((Object)" read");
            String _name_9 = fbProperty_1.getName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_name_9);
            _builder.append((Object)_firstUpper, "\t");
            _builder.append((Object)"() {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            FunctionblockModel _type_2 = fbProperty_1.getType();
            String _name_10 = _type_2.getName();
            _builder.append((Object)_name_10, "\t\t");
            _builder.append((Object)" ");
            String _name_11 = fbProperty_1.getName();
            _builder.append((Object)_name_11, "\t\t");
            _builder.append((Object)" = new ");
            FunctionblockModel _type_3 = fbProperty_1.getType();
            String _name_12 = _type_3.getName();
            _builder.append((Object)_name_12, "\t\t");
            _builder.append((Object)"();");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"try {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"//TODO: insert code that reads ");
            String _name_13 = fbProperty_1.getName();
            _builder.append((Object)_name_13, "\t\t\t");
            _builder.append((Object)" and converts into ");
            FunctionblockModel _type_4 = fbProperty_1.getType();
            String _name_14 = _type_4.getName();
            _builder.append((Object)_name_14, "\t\t\t");
            _builder.append((Object)" object");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"String value = this.bluetoothGatt.readCharacteristicValue(\"\");");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"} catch (KuraException e) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t ");
            _builder.append((Object)"logger.error(e.toString());");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return ");
            String _name_15 = fbProperty_1.getName();
            _builder.append((Object)_name_15, "\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public void enable");
            String _name_16 = fbProperty_1.getName();
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_16);
            _builder.append((Object)_firstUpper_1, "\t");
            _builder.append((Object)"() {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"//TODO: Insert code here to enable ");
            String _name_17 = fbProperty_1.getName();
            _builder.append((Object)_name_17, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"this.bluetoothGatt.writeCharacteristicValue(\"\", \"\");");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public boolean connect(String adapterName) {");
        _builder.newLine();
        _builder.append((Object)"\t\t ");
        _builder.append((Object)"this.bluetoothGatt = this.device.getBluetoothGatt();");
        _builder.newLine();
        _builder.append((Object)"\t        ");
        _builder.append((Object)"boolean connected = false;");
        _builder.newLine();
        _builder.append((Object)"\t        ");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t            ");
        _builder.append((Object)"connected = this.bluetoothGatt.connect(adapterName);");
        _builder.newLine();
        _builder.append((Object)"\t        ");
        _builder.append((Object)"} catch (KuraException e) {");
        _builder.newLine();
        _builder.append((Object)"\t            ");
        _builder.append((Object)"logger.error(e.toString());");
        _builder.newLine();
        _builder.append((Object)"\t        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t        ");
        _builder.append((Object)"if (connected) {");
        _builder.newLine();
        _builder.append((Object)"\t            ");
        _builder.append((Object)"this.bluetoothGatt.setBluetoothLeNotificationListener(this);");
        _builder.newLine();
        _builder.append((Object)"\t            ");
        _builder.append((Object)"this.isConnected = true;");
        _builder.newLine();
        _builder.append((Object)"\t            ");
        _builder.append((Object)"return true;");
        _builder.newLine();
        _builder.append((Object)"\t        ");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t            ");
        _builder.append((Object)"// If connect command is not executed, close gatttool");
        _builder.newLine();
        _builder.append((Object)"\t            ");
        _builder.append((Object)"this.bluetoothGatt.disconnect();");
        _builder.newLine();
        _builder.append((Object)"\t            ");
        _builder.append((Object)"this.isConnected = false;");
        _builder.newLine();
        _builder.append((Object)"\t            ");
        _builder.append((Object)"return false;");
        _builder.newLine();
        _builder.append((Object)"\t        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public String getResourceId() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"//TODO: insert code that reads technical device id from the device");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return getBluetoothDevice().getAdress();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        return _builder.toString();
    }
}

