/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.internal.external;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import javax.management.JMException;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.repository.ArtifactDescriptorPersister;
import org.eclipse.virgo.repository.DuplicateArtifactException;
import org.eclipse.virgo.repository.IndexFormatException;
import org.eclipse.virgo.repository.RepositoryAwareArtifactDescriptor;
import org.eclipse.virgo.repository.RepositoryCreationException;
import org.eclipse.virgo.repository.XmlArtifactDescriptorPersister;
import org.eclipse.virgo.repository.codec.XMLRepositoryCodec;
import org.eclipse.virgo.repository.configuration.ExternalStorageRepositoryConfiguration;
import org.eclipse.virgo.repository.internal.ArtifactDescriptorDepository;
import org.eclipse.virgo.repository.internal.MutableRepository;
import org.eclipse.virgo.repository.internal.PersistentRepository;
import org.eclipse.virgo.repository.internal.RepositoryLogEvents;
import org.eclipse.virgo.repository.internal.external.AntPathMatchingFileSystemSearcher;
import org.eclipse.virgo.repository.internal.external.ExternalArtifactStore;
import org.eclipse.virgo.repository.internal.management.StandardExternalStorageRepositoryInfo;
import org.eclipse.virgo.repository.management.RepositoryInfo;
import org.eclipse.virgo.util.io.FileSystemUtils;
import org.eclipse.virgo.util.osgi.manifest.VersionRange;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExternalStorageRepository
extends PersistentRepository
implements MutableRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalStorageRepository.class);
    private final EventLogger eventLogger;
    private final AntPathMatchingFileSystemSearcher antPathMatchingFileSystemSearcher;

    public ExternalStorageRepository(ExternalStorageRepositoryConfiguration configuration, EventLogger eventLogger) throws RepositoryCreationException, IndexFormatException {
        this(configuration, (ArtifactDescriptorPersister)new XmlArtifactDescriptorPersister(new XMLRepositoryCodec(), configuration.getName(), configuration.getIndexLocation()), eventLogger);
    }

    public ExternalStorageRepository(ExternalStorageRepositoryConfiguration configuration, ArtifactDescriptorPersister artifactDescriptorPersister, EventLogger eventLogger) throws RepositoryCreationException, IndexFormatException {
        super(configuration, artifactDescriptorPersister, eventLogger);
        this.eventLogger = eventLogger;
        this.antPathMatchingFileSystemSearcher = new AntPathMatchingFileSystemSearcher(configuration.getSearchPattern());
        if (artifactDescriptorPersister.loadArtifacts().isEmpty()) {
            this.initialiseDepository(configuration.getName(), eventLogger);
        }
    }

    private void initialiseDepository(String repositoryName, EventLogger eventLogger) throws RepositoryCreationException {
        ExternalArtifactStore artifactStore = new ExternalArtifactStore(this.antPathMatchingFileSystemSearcher);
        Set<File> artifacts = artifactStore.getArtifacts();
        ArtifactDescriptorDepository artifactDepository = this.getDepository();
        for (File artifact : artifacts) {
            try {
                RepositoryAwareArtifactDescriptor artifactDescriptor = this.createArtifactDescriptor(artifact);
                if (artifactDescriptor == null) continue;
                artifactDepository.addArtifactDescriptor(artifactDescriptor);
            }
            catch (DuplicateArtifactException duplicateArtifactException) {
                LOGGER.warn("Duplicate artifact '{}' discovered in external repository '{}'.", (Object)artifact, (Object)repositoryName);
            }
        }
        try {
            artifactDepository.persist();
        }
        catch (IOException ioe) {
            LOGGER.error(String.format("Persisting repository '%s' failed.", repositoryName), (Throwable)ioe);
            eventLogger.log((LogEvent)RepositoryLogEvents.REPOSITORY_INDEX_NOT_PERSISTED, (Throwable)ioe, new Object[]{this.getName()});
            throw new RepositoryCreationException("Failed to persist depository for repository '" + repositoryName + "'", ioe);
        }
    }

    @Override
    protected RepositoryInfo createMBean() throws JMException {
        return new StandardExternalStorageRepositoryInfo(this.getName(), this.getDepository(), this);
    }

    @Override
    public RepositoryAwareArtifactDescriptor publish(URI uri) throws DuplicateArtifactException {
        if (!"file".equals(uri.getScheme())) {
            LOGGER.error("Uri '{}' not supported for artifact publication to external repository '{}'.", (Object)uri, (Object)this.getName());
            this.eventLogger.log((LogEvent)RepositoryLogEvents.ARTIFACT_NOT_PUBLISHED, new Object[]{uri, this.getName()});
            throw new IllegalArgumentException("'" + uri.getScheme() + "' is an unsupported scheme for artifact publication. Supported schemes are: 'file'.");
        }
        RepositoryAwareArtifactDescriptor artifactDescriptor = this.createArtifactDescriptor(new File(uri));
        if (artifactDescriptor == null) {
            LOGGER.error("Uri '{}' not a valid artifact for external repository '{}'.", (Object)uri, (Object)this.getName());
            this.eventLogger.log((LogEvent)RepositoryLogEvents.ARTIFACT_NOT_PUBLISHED, new Object[]{uri, this.getName(), uri.getScheme()});
            throw new IllegalArgumentException("'" + uri + "' is not a valid artifact for publication to '" + this.getName() + "'.");
        }
        this.getDepository().addArtifactDescriptor(artifactDescriptor);
        return artifactDescriptor;
    }

    @Override
    public boolean retract(String type, String name, Version version) {
        RepositoryAwareArtifactDescriptor artifactDescriptor = this.get(type, name, VersionRange.createExactRange((Version)version));
        if (artifactDescriptor != null) {
            return this.getDepository().removeArtifactDescriptor(artifactDescriptor);
        }
        LOGGER.warn("Artifact (type='{}',name='{}',version='{}') not in repository '{}' and cannot be retracted.", new Object[]{type, name, version, this.getName()});
        return false;
    }

    @Override
    public Set<String> getArtifactLocations(String filename) {
        File rootDir = this.antPathMatchingFileSystemSearcher.getRootDir();
        Set<String> locations = this.locationsInDirs(rootDir, filename);
        return locations;
    }

    private Set<String> locationsInDirs(File dir, String filename) {
        HashSet<String> locations = new HashSet<String>();
        String pathHere = new File(dir, filename).getAbsolutePath();
        if (this.antPathMatchingFileSystemSearcher.matchPath(pathHere)) {
            locations.add(pathHere);
        }
        if (dir.isDirectory()) {
            File[] fileArray = FileSystemUtils.listFiles((File)dir);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    locations.addAll(this.locationsInDirs(f, filename));
                }
                ++n2;
            }
        }
        return locations;
    }
}

