/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.dmfragment.internal;

import org.eclipse.gemini.blueprint.service.importer.support.OsgiServiceProxyFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ContextClosedEvent;

final class ApplicationContextShutdownBean
implements ApplicationListener<ApplicationEvent> {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationContextShutdownBean.class);

    ApplicationContextShutdownBean() {
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextClosedEvent) {
            logger.info("Processing ContextClosedEvent '{}'", (Object)event);
            ApplicationContext applicationContext = ((ApplicationContextEvent)event).getApplicationContext();
            ApplicationContextShutdownBean.disableServiceProxyRetry(applicationContext);
        }
    }

    static void disableServiceProxyRetry(ApplicationContext applicationContext) {
        for (OsgiServiceProxyFactoryBean proxyBean : BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)applicationContext, OsgiServiceProxyFactoryBean.class, (boolean)true, (boolean)false).values()) {
            logger.info("Setting timeout to 0 for proxy '{}' of application context '{}'", (Object)proxyBean, (Object)applicationContext);
            proxyBean.setTimeout(0L);
        }
    }
}

