/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.blueprint.extensions.annotation;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.gemini.blueprint.extender.OsgiServiceDependencyFactory;
import org.eclipse.gemini.blueprint.extensions.annotation.ServiceReference;
import org.eclipse.gemini.blueprint.service.exporter.support.OsgiServiceFactoryBean;
import org.eclipse.gemini.blueprint.service.importer.OsgiServiceDependency;
import org.eclipse.gemini.blueprint.service.importer.support.Availability;
import org.eclipse.gemini.blueprint.service.importer.support.OsgiServiceCollectionProxyFactoryBean;
import org.eclipse.gemini.blueprint.service.importer.support.OsgiServiceProxyFactoryBean;
import org.eclipse.gemini.blueprint.util.OsgiFilterUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

class ServiceReferenceDependencyBeanFactoryPostProcessor
implements OsgiServiceDependencyFactory {
    private final Log logger = LogFactory.getLog(this.getClass());

    ServiceReferenceDependencyBeanFactoryPostProcessor() {
    }

    public Collection<OsgiServiceDependency> getServiceDependencies(BundleContext bundleContext, ConfigurableListableBeanFactory beanFactory) throws BeansException, InvalidSyntaxException, BundleException {
        String[] beanDefinitionNames;
        LinkedHashSet<OsgiServiceDependency> dependencies = new LinkedHashSet<OsgiServiceDependency>();
        for (String definitionName : beanDefinitionNames = beanFactory.getBeanDefinitionNames()) {
            BeanDefinition definition = beanFactory.getBeanDefinition(definitionName);
            String className = definition.getBeanClassName();
            if (className == null || className.equals(OsgiServiceProxyFactoryBean.class.getName()) || className.equals(OsgiServiceFactoryBean.class.getName()) || className.equals(OsgiServiceCollectionProxyFactoryBean.class.getName())) continue;
            try {
                Class<?> clazz = Class.forName(className, true, beanFactory.getBeanClassLoader());
                dependencies.addAll(this.getClassServiceDependencies(clazz, definitionName, definition));
            }
            catch (ClassNotFoundException cnfe) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Could not load class [" + className + "] for [" + bundleContext.getBundle().getSymbolicName() + "]"));
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Processing annotations for [" + bundleContext.getBundle().getSymbolicName() + "] found " + dependencies));
        }
        return dependencies;
    }

    private Set<OsgiServiceDependency> getClassServiceDependencies(final Class<?> beanClass, final String beanName, final BeanDefinition definition) {
        final LinkedHashSet<OsgiServiceDependency> dependencies = new LinkedHashSet<OsgiServiceDependency>();
        ReflectionUtils.doWithMethods(beanClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(final Method method) {
                final ServiceReference s = (ServiceReference)AnnotationUtils.getAnnotation((Method)method, ServiceReference.class);
                if (s != null && method.getParameterTypes().length == 1 && !Collection.class.isAssignableFrom(method.getParameterTypes()[0]) && !definition.getPropertyValues().contains(ServiceReferenceDependencyBeanFactoryPostProcessor.this.getPropertyName(method))) {
                    try {
                        if (ServiceReferenceDependencyBeanFactoryPostProcessor.this.logger.isDebugEnabled()) {
                            ServiceReferenceDependencyBeanFactoryPostProcessor.this.logger.debug((Object)("Processing annotation [" + s + "] for [" + beanClass.getName() + "." + method.getName() + "()] on bean [" + beanName + "]"));
                        }
                        dependencies.add(new OsgiServiceDependency(){

                            public Filter getServiceFilter() {
                                return ServiceReferenceDependencyBeanFactoryPostProcessor.this.getUnifiedFilter(s, method, beanName);
                            }

                            public boolean isMandatory() {
                                return s.cardinality() == Availability.MANDATORY;
                            }

                            public String getBeanName() {
                                return beanName;
                            }

                            public String toString() {
                                return beanName + "." + method.getName() + ": " + this.getServiceFilter() + (this.isMandatory() ? " (mandatory)" : " (optional)");
                            }
                        });
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Error processing service annotation", e);
                    }
                }
            }
        });
        return dependencies;
    }

    private String getPropertyName(Method method) {
        String name = method.getName();
        if (name.startsWith("set")) {
            return Character.toLowerCase(name.charAt(3)) + name.substring(4);
        }
        return name;
    }

    private Filter getUnifiedFilter(ServiceReference s, Method writeMethod, String beanName) {
        String filter;
        if (s.serviceTypes().length == 0 || s.serviceTypes().length == 1 && s.serviceTypes()[0].equals(ServiceReference.class)) {
            Class<?>[] params = writeMethod.getParameterTypes();
            if (params.length != 1) {
                throw new IllegalArgumentException("Setter for [" + beanName + "] must have only one argument");
            }
            filter = OsgiFilterUtils.unifyFilter((Class[])new Class[]{params[0]}, (String)s.filter());
        } else {
            filter = OsgiFilterUtils.unifyFilter((Class[])s.serviceTypes(), (String)s.filter());
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("unified classes=[" + filter + "]"));
        }
        if (s.serviceBeanName().length() > 0) {
            filter = OsgiFilterUtils.unifyFilter((String)"org.eclipse.gemini.blueprint.bean.name", (String[])new String[]{s.serviceBeanName()}, (String)filter);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("unified serviceBeanName [" + ObjectUtils.nullSafeToString((Object)s.serviceBeanName()) + "] and filter=[" + filter + "]"));
            }
        }
        return OsgiFilterUtils.createFilter((String)filter);
    }
}

