/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.osgi.framework;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.virgo.kernel.osgi.framework.OsgiFrameworkUtils;
import org.eclipse.virgo.kernel.osgi.framework.OsgiServiceHolder;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceUtils {
    public static final String PROPERTY_KERNEL_STARTUP_WAIT_LIMIT = "org.eclipse.virgo.kernel.startup.wait.limit";
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceUtils.class);
    private static final int DEFAULT_STARTUP_WAIT_LIMIT = 180;
    private static volatile int maxSecondsWaitForService = 180;
    private static volatile long maxMillisWaitForService = 0L;
    private static final Object monitor = new Object();

    public ServiceUtils() {
        try {
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public static <T> T getPotentiallyDelayedService(BundleContext context, Class<T> serviceClass) throws TimeoutException, InterruptedException {
        try {
            T service = null;
            long millisWaited = 0L;
            while (service == null && millisWaited <= ServiceUtils.getInitialisedWaitLimit(context)) {
                try {
                    OsgiServiceHolder<T> serviceHolder = OsgiFrameworkUtils.getService(context, serviceClass);
                    if (serviceHolder != null) {
                        service = serviceHolder.getService();
                        continue;
                    }
                    millisWaited += ServiceUtils.sleepABitMore();
                }
                catch (IllegalStateException illegalStateException) {}
            }
            if (service == null) {
                throw new TimeoutException(serviceClass.getName());
            }
            return service;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getInitialisedWaitLimit(BundleContext context) {
        try {
            if (maxMillisWaitForService == 0L) {
                Object object = monitor;
                synchronized (object) {
                    if (maxMillisWaitForService == 0L) {
                        maxSecondsWaitForService = ServiceUtils.readBundleStartupWaitLimit(context);
                        maxMillisWaitForService = TimeUnit.SECONDS.toMillis(maxSecondsWaitForService);
                    }
                }
            }
            return maxMillisWaitForService;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public static long getWaitLimitSeconds() {
        try {
            return maxSecondsWaitForService;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static int readBundleStartupWaitLimit(BundleContext context) {
        try {
            String waitLimitProperty = ServiceUtils.readFrameworkProperty(PROPERTY_KERNEL_STARTUP_WAIT_LIMIT, context);
            if (!ServiceUtils.hasText(waitLimitProperty)) {
                return 180;
            }
            try {
                return Integer.parseInt(waitLimitProperty);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.warn("Could not parse property {} with value '{}'. Using default limit {} seconds", new Object[]{PROPERTY_KERNEL_STARTUP_WAIT_LIMIT, waitLimitProperty, 180});
                return 180;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static String readFrameworkProperty(String propertyKey, BundleContext context) {
        try {
            return context.getProperty(propertyKey);
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static boolean hasText(String string) {
        try {
            return string != null && !string.trim().isEmpty();
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static long sleepABitMore() throws InterruptedException {
        try {
            long before = System.currentTimeMillis();
            Thread.sleep(100L);
            return System.currentTimeMillis() - before;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }
}

