/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.ui.views;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.virgo.ide.runtime.core.ServerCorePlugin;
import org.eclipse.virgo.ide.runtime.core.provisioning.IBundleRepositoryChangeListener;
import org.eclipse.virgo.ide.runtime.internal.ui.filters.FilterAction;
import org.eclipse.virgo.ide.runtime.internal.ui.projects.ServerProjectManager;
import org.eclipse.virgo.ide.runtime.internal.ui.repository.RefreshBundleJob;
import org.eclipse.virgo.ide.runtime.ui.views.CommonView;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;

public class ArtefactCommonView
extends CommonView {
    private static final String FILTER_ACTION_GROUP = "filters";
    private IBundleRepositoryChangeListener repositoryListener;

    public void createPartControl(Composite aParent) {
        FilterAction[] filterActions;
        super.createPartControl(aParent);
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager manager = actionBars.getToolBarManager();
        manager.add((IContributionItem)new Separator(FILTER_ACTION_GROUP));
        FilterAction[] filterActionArray = filterActions = FilterAction.createSet(this);
        int n = filterActions.length;
        int n2 = 0;
        while (n2 < n) {
            FilterAction action = filterActionArray[n2];
            manager.appendToGroup(FILTER_ACTION_GROUP, (IAction)action);
            ++n2;
        }
        this.repositoryListener = new IBundleRepositoryChangeListener(){

            public void bundleRepositoryChanged(IRuntime runtime) {
                ArtefactCommonView.this.refreshView();
            }
        };
        ServerCorePlugin.getArtefactRepositoryManager().addBundleRepositoryChangeListener(this.repositoryListener);
    }

    protected void refreshAll() {
        for (IServer server : this.getServers()) {
            RefreshBundleJob.execute(this.getSite().getShell(), server.getRuntime());
            ServerProjectManager.getInstance().getProject(server).refresh();
        }
        super.refreshAll();
    }

    protected String getListContentId() {
        return "org.eclipse.virgo.ide.runtime.ui.flattenedRuntimeArtefacts";
    }

    protected String getTreeContentId() {
        return "org.eclipse.virgo.ide.runtime.ui.runtimeArtefacts";
    }

    protected String getViewId() {
        return "org.eclipse.virgo.ide.runtime.ui.ArtefactsDetailView";
    }
}

