/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.bundlor.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.virgo.bundlor.EntryScannerListener;
import org.eclipse.virgo.bundlor.ManifestGenerator;
import org.eclipse.virgo.bundlor.support.ArtifactAnalyzer;
import org.eclipse.virgo.bundlor.support.ManifestContributor;
import org.eclipse.virgo.bundlor.support.ManifestGeneratorContributors;
import org.eclipse.virgo.bundlor.support.ManifestModifier;
import org.eclipse.virgo.bundlor.support.ManifestReader;
import org.eclipse.virgo.bundlor.support.ManifestTemplateModifier;
import org.eclipse.virgo.bundlor.support.PartialManifestModifier;
import org.eclipse.virgo.bundlor.support.PartialManifestResolver;
import org.eclipse.virgo.bundlor.support.StandardManifestGenerator;
import org.eclipse.virgo.bundlor.support.TemplateHeaderReader;
import org.eclipse.virgo.bundlor.support.contributors.BundleClassPathArtifactAnalyzer;
import org.eclipse.virgo.bundlor.support.contributors.ExcludedImportAndExportPartialManifestModifier;
import org.eclipse.virgo.bundlor.support.contributors.IgnoredExistingHeadersManifestModifier;
import org.eclipse.virgo.bundlor.support.contributors.JspArtifactAnalyzer;
import org.eclipse.virgo.bundlor.support.contributors.ManifestTemplateDirectiveMigrator;
import org.eclipse.virgo.bundlor.support.contributors.OsgiProfileManifestTemplateModifier;
import org.eclipse.virgo.bundlor.support.contributors.StaticResourceArtifactAnalyzer;
import org.eclipse.virgo.bundlor.support.contributors.ToolStampManifestModifier;
import org.eclipse.virgo.bundlor.support.contributors.xml.BlueprintArtifactAnalyzer;
import org.eclipse.virgo.bundlor.support.contributors.xml.HibernateMappingArtifactAnalyzer;
import org.eclipse.virgo.bundlor.support.contributors.xml.JpaPersistenceArtifactAnalyzer;
import org.eclipse.virgo.bundlor.support.contributors.xml.Log4JXmlArtifactAnalyzer;
import org.eclipse.virgo.bundlor.support.contributors.xml.SpringApplicationContextArtifactAnalyzer;
import org.eclipse.virgo.bundlor.support.contributors.xml.WebApplicationArtifactAnalyzer;
import org.eclipse.virgo.bundlor.support.partialmanifest.ReadablePartialManifest;
import org.eclipse.virgo.bundlor.support.partialmanifest.StandardPartialManifestResolver;
import org.eclipse.virgo.bundlor.support.partialmanifest.StandardReadablePartialManifest;
import org.eclipse.virgo.bundlor.support.properties.PropertiesSource;
import org.eclipse.virgo.bundlor.support.propertysubstitution.PlaceholderManifestAndTemplateModifier;
import org.eclipse.virgo.util.parser.manifest.ManifestContents;

class ManifestGeneratorFactory {
    ManifestGeneratorFactory() {
    }

    public static ManifestGenerator create(ReadablePartialManifest partialManifest, ArtifactAnalyzer artifactAnalyzer, PropertiesSource ... properties) {
        ManifestGeneratorContributors contributors = ManifestGeneratorFactory.create(artifactAnalyzer, properties);
        contributors.addManifestModifier((ManifestModifier)new HeaderRemovingManifestModifier());
        contributors.addManifestTemplateModifier((ManifestTemplateModifier)new HeaderRemovingTemplateManifestModifier());
        contributors.setReadablePartialManifest(partialManifest);
        if (partialManifest instanceof EntryScannerListener) {
            contributors.addEntryScannerListener((EntryScannerListener)partialManifest);
        }
        return new StandardManifestGenerator(contributors);
    }

    private static ManifestGeneratorContributors create(ArtifactAnalyzer artifactAnalyzer, PropertiesSource ... propertiesSources) {
        ManifestGeneratorContributors contributors = new ManifestGeneratorContributors();
        Properties properties = ManifestGeneratorFactory.combineProperties(propertiesSources);
        BlueprintArtifactAnalyzer blueprintArtifactAnalyzer = new BlueprintArtifactAnalyzer();
        IgnoredExistingHeadersManifestModifier ignoredExistingHeadersManifestModifier = new IgnoredExistingHeadersManifestModifier();
        ExcludedImportAndExportPartialManifestModifier excludedImportAndExportPartialManifestModifier = new ExcludedImportAndExportPartialManifestModifier();
        PlaceholderManifestAndTemplateModifier placeholderManifestAndTemplateModifier = new PlaceholderManifestAndTemplateModifier(properties);
        ManifestTemplateDirectiveMigrator manifestTemplateDirectiveMigrator = new ManifestTemplateDirectiveMigrator();
        StandardPartialManifestResolver partialManifestResolver = new StandardPartialManifestResolver();
        ArrayList<Object> analyzers = new ArrayList<Object>();
        BundleClassPathArtifactAnalyzer bundleClassPathArtifactAnalyzer = new BundleClassPathArtifactAnalyzer(analyzers);
        contributors.addArtifactAnalyzer(artifactAnalyzer).addArtifactAnalyzer((ArtifactAnalyzer)new StaticResourceArtifactAnalyzer()).addArtifactAnalyzer((ArtifactAnalyzer)new HibernateMappingArtifactAnalyzer()).addArtifactAnalyzer((ArtifactAnalyzer)new JpaPersistenceArtifactAnalyzer()).addArtifactAnalyzer((ArtifactAnalyzer)new Log4JXmlArtifactAnalyzer()).addArtifactAnalyzer((ArtifactAnalyzer)new SpringApplicationContextArtifactAnalyzer()).addArtifactAnalyzer((ArtifactAnalyzer)blueprintArtifactAnalyzer).addArtifactAnalyzer((ArtifactAnalyzer)new WebApplicationArtifactAnalyzer()).addArtifactAnalyzer((ArtifactAnalyzer)bundleClassPathArtifactAnalyzer).addArtifactAnalyzer((ArtifactAnalyzer)new JspArtifactAnalyzer());
        analyzers.add(artifactAnalyzer);
        analyzers.add(new StaticResourceArtifactAnalyzer());
        analyzers.add(new HibernateMappingArtifactAnalyzer());
        analyzers.add(new JpaPersistenceArtifactAnalyzer());
        analyzers.add(new Log4JXmlArtifactAnalyzer());
        analyzers.add(new SpringApplicationContextArtifactAnalyzer());
        analyzers.add(blueprintArtifactAnalyzer);
        analyzers.add(new WebApplicationArtifactAnalyzer());
        analyzers.add(bundleClassPathArtifactAnalyzer);
        analyzers.add(new JspArtifactAnalyzer());
        contributors.addManifestReader((ManifestReader)excludedImportAndExportPartialManifestModifier).addManifestReader((ManifestReader)ignoredExistingHeadersManifestModifier).addManifestReader((ManifestReader)blueprintArtifactAnalyzer);
        contributors.addManifestModifier((ManifestModifier)placeholderManifestAndTemplateModifier).addManifestModifier((ManifestModifier)ignoredExistingHeadersManifestModifier).addManifestModifier((ManifestModifier)new ToolStampManifestModifier());
        contributors.addManifestTemplateModifier((ManifestTemplateModifier)manifestTemplateDirectiveMigrator).addManifestTemplateModifier((ManifestTemplateModifier)placeholderManifestAndTemplateModifier).addManifestTemplateModifier((ManifestTemplateModifier)new OsgiProfileManifestTemplateModifier(properties));
        contributors.addManifestContributor((ManifestContributor)bundleClassPathArtifactAnalyzer);
        contributors.addPartialManifestModifier((PartialManifestModifier)manifestTemplateDirectiveMigrator).addPartialManifestModifier((PartialManifestModifier)excludedImportAndExportPartialManifestModifier);
        contributors.addTemplateHeaderReader((TemplateHeaderReader)excludedImportAndExportPartialManifestModifier).addTemplateHeaderReader((TemplateHeaderReader)ignoredExistingHeadersManifestModifier).addTemplateHeaderReader((TemplateHeaderReader)placeholderManifestAndTemplateModifier).addTemplateHeaderReader((TemplateHeaderReader)partialManifestResolver);
        contributors.setReadablePartialManifest((ReadablePartialManifest)new StandardReadablePartialManifest());
        contributors.setPartialManifestResolver((PartialManifestResolver)partialManifestResolver);
        return contributors;
    }

    private static Properties combineProperties(PropertiesSource ... propertiesSources) {
        PropertiesSource[] sortedPropertiesSources = new PropertiesSource[propertiesSources.length];
        System.arraycopy(propertiesSources, 0, sortedPropertiesSources, 0, propertiesSources.length);
        Arrays.sort(sortedPropertiesSources, new Comparator<PropertiesSource>(){

            @Override
            public int compare(PropertiesSource o1, PropertiesSource o2) {
                if (o1.getPriority() == o2.getPriority()) {
                    return 0;
                }
                if (o1.getPriority() > o2.getPriority()) {
                    return 1;
                }
                return -1;
            }
        });
        Properties properties = new Properties();
        PropertiesSource[] propertiesSourceArray = propertiesSources;
        int n = propertiesSources.length;
        int n2 = 0;
        while (n2 < n) {
            PropertiesSource source = propertiesSourceArray[n2];
            properties.putAll((Map<?, ?>)source.getProperties());
            ++n2;
        }
        return properties;
    }

    static class HeaderRemovingManifestModifier
    implements ManifestModifier {
        HeaderRemovingManifestModifier() {
        }

        public void modify(ManifestContents manifest) {
            manifest.getMainAttributes().remove("Import-Library");
            manifest.getMainAttributes().remove("Import-Bundle");
            manifest.getMainAttributes().remove("Export-Template");
            manifest.getMainAttributes().remove("Import-Template");
            manifest.getMainAttributes().remove("Excluded-Exports");
            manifest.getMainAttributes().remove("Excluded-Imports");
            manifest.getMainAttributes().remove("Ignored-Existing-Headers");
            manifest.getMainAttributes().remove("Test-Import-Package");
            manifest.getMainAttributes().remove("Test-Import-Library");
            manifest.getMainAttributes().remove("Test-Import-Bundle");
            manifest.getMainAttributes().remove("Import-Package");
            manifest.getMainAttributes().remove("Export-Package");
        }
    }

    static class HeaderRemovingTemplateManifestModifier
    implements ManifestTemplateModifier {
        HeaderRemovingTemplateManifestModifier() {
        }

        public void modify(ManifestContents manifest) {
            manifest.getMainAttributes().remove("Test-Import-Package");
            manifest.getMainAttributes().remove("Test-Import-Library");
            manifest.getMainAttributes().remove("Test-Import-Bundle");
        }
    }
}

