/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.api;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.viatra.query.runtime.api.IQueryGroup;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.impl.BaseQueryGroup;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

public class LazyLoadingQueryGroup
extends BaseQueryGroup {
    private final Set<? extends Supplier<IQuerySpecification<?>>> providers;
    private Set<IQuerySpecification<?>> specifications = null;

    public LazyLoadingQueryGroup(Set<? extends Supplier<IQuerySpecification<?>>> providers) {
        Preconditions.checkArgument((providers != null ? 1 : 0) != 0, (String)"The set of providers must not be null");
        this.providers = providers;
    }

    public static IQueryGroup of(Set<? extends Supplier<IQuerySpecification<?>>> querySpecifications) {
        return new LazyLoadingQueryGroup(querySpecifications);
    }

    @Override
    public Set<IQuerySpecification<?>> getSpecifications() {
        if (this.specifications == null) {
            try {
                this.specifications = this.providers.stream().filter(Objects::nonNull).map(Supplier::get).filter(Objects::nonNull).collect(Collectors.toSet());
            }
            catch (Exception e) {
                String errorMessage = "Exception occurred while accessing query specification from provider: " + e.getMessage();
                ViatraQueryLoggingUtil.getLogger(this.getClass()).error((Object)errorMessage);
                return Collections.emptySet();
            }
        }
        return this.specifications;
    }
}

