/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.migrator;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class FileStringReplacer {
    private final IFile file;
    private String data;

    public FileStringReplacer(IFile file) throws IOException, CoreException {
        this.file = file;
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream input = file.getContents();){
            this.data = CharStreams.toString((Readable)new InputStreamReader(input, Charsets.UTF_8));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public boolean replacePattern(String pattern, String replacement) {
        String newData = this.data.replaceAll(pattern, replacement);
        boolean changed = !newData.equals(this.data);
        this.data = newData;
        return changed;
    }

    public void save() throws UnsupportedEncodingException, CoreException {
        this.file.setContents((InputStream)new ByteArrayInputStream(this.data.getBytes(this.file.getCharset(true))), true, true, null);
    }
}

