/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.evolutionary.stopconditions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.evolutionary.interfaces.IStopCondition;
import org.eclipse.viatra.dse.objectives.TrajectoryFitness;

public class CompositeStopCondition
implements IStopCondition {
    private List<IStopCondition> stopConditions = new ArrayList<IStopCondition>(2);
    private CompositeType type = CompositeType.AND;

    public CompositeStopCondition() {
    }

    public CompositeStopCondition(IStopCondition stopCondition1, IStopCondition stopCondition2) {
        this.stopConditions.add(stopCondition1);
        this.stopConditions.add(stopCondition2);
    }

    public void addStopCondition(IStopCondition stopCondition) {
        this.stopConditions.add(stopCondition);
    }

    public CompositeStopCondition withStopCondition(IStopCondition stopCondition) {
        this.stopConditions.add(stopCondition);
        return this;
    }

    public void setCompositeType(CompositeType type) {
        this.type = type;
    }

    public CompositeStopCondition withCompositeType(CompositeType type) {
        this.type = type;
        return this;
    }

    @Override
    public void init(ThreadContext context) {
        for (IStopCondition stopCondition : this.stopConditions) {
            stopCondition.init(context);
        }
    }

    @Override
    public boolean checkStopCondition(Collection<TrajectoryFitness> survivedPopulation) {
        if (this.type.equals((Object)CompositeType.AND)) {
            for (IStopCondition stopCondition : this.stopConditions) {
                if (stopCondition.checkStopCondition(survivedPopulation)) continue;
                return false;
            }
            return true;
        }
        for (IStopCondition stopCondition : this.stopConditions) {
            if (!stopCondition.checkStopCondition(survivedPopulation)) continue;
            return true;
        }
        return false;
    }

    public static enum CompositeType {
        AND,
        OR;

    }
}

